<?php
session_start();
if (!isset($_SESSION['idusuario']) || !isset($_SESSION['permiso'])) {
    die(json_encode(["error" => "Sesión no válida"]));
}

$id_usuario = $_SESSION['idusuario'];
$permiso = $_SESSION['permiso'];

include("conex.php");

// Verificar conexión
if (!$conn) {
    die(json_encode(["error" => "Error de conexión a la base de datos"]));
}

$tabla = [];

if ($permiso == 777) {
    // Consulta segura
    $sql = "SELECT 
                d.iddatadai, d.marca, d.descripcion, d.modelo, d.chasis, d.motor, d.color, 
                d.id_guia, d.id_guia2,
                g.cedula AS entrada_cedula, g.nombre AS entrada_nombre, g.empresa AS entrada_empresa, 
                g.fecha AS entrada_fecha, g.numero AS entrada_numero, g.numeroacta AS entrada_acta, 
                g.observacionesd AS entrada_observacion, g.placa AS entrada_placa, 
                gs.idguia AS salida_id_guia, gs.cedula AS salida_cedula, gs.nombre AS salida_nombre, 
                gs.empresa AS salida_empresa, gs.fecha AS salida_fecha, gs.numero AS salida_numero, 
                gs.numeroacta AS salida_acta, gs.observacionesd AS salida_observacion, gs.placa AS salida_placa
            FROM tb_datadai AS d
            LEFT JOIN tb_guia AS g ON g.idguia = d.id_guia
            LEFT JOIN tb_guia AS gs ON gs.idguia = d.id_guia2
            WHERE d.id_estado > 2 AND d.dai <> 'Simple' AND d.condicion = 1";

    if ($consulta = mysqli_query($conn, $sql)) {
        while ($row = mysqli_fetch_assoc($consulta)) {
            // Escapar datos con valores predeterminados para evitar errores
            $id = htmlspecialchars($row['iddatadai']);
            $marca = htmlspecialchars($row['marca']);
            $descripcion = htmlspecialchars($row['descripcion']);
            $modelo = htmlspecialchars($row['modelo']);
            $chasis = htmlspecialchars($row['chasis']);
            $motor = htmlspecialchars($row['motor']);
            $color = htmlspecialchars($row['color']);

            // Datos de la guía de entrada
            $id_guia = htmlspecialchars($row['id_guia']);
            $cedula = htmlspecialchars($row['entrada_cedula']);
            $nombre = htmlspecialchars($row['entrada_nombre']);
            $empresa = htmlspecialchars($row['entrada_empresa']);
            $fecha = htmlspecialchars($row['entrada_fecha']);
            $numero = htmlspecialchars($row['entrada_numero']);
            $acta = htmlspecialchars($row['entrada_acta']);
            $observacionesd = htmlspecialchars($row['entrada_observacion']);
            $placa = htmlspecialchars($row['entrada_placa']);

            // Datos de la guía de salida
            $id_guia_s = htmlspecialchars($row['id_guia2']);
            $cedula_s = htmlspecialchars($row['salida_cedula']);
            $nombre_s = htmlspecialchars($row['salida_nombre']);
            $empresa_s = htmlspecialchars($row['salida_empresa']);
            $fecha_s = htmlspecialchars($row['salida_fecha']);
            $numero_s = htmlspecialchars($row['salida_numero']);
            $acta_s = htmlspecialchars($row['salida_acta']);
            $observacionesd_s = htmlspecialchars($row['salida_observacion']);
            $placa_s = htmlspecialchars($row['salida_placa']);

            // Crear el botón
            $ingresar = sprintf(
                '<a id="btnnotiguia%s" data-id="%s" data-id_guia="%s" data-cedula="%s" data-nombre="%s" data-empresa="%s" data-fecha="%s" data-numero="%s" data-acta="%s" data-observacionesd="%s" data-placa="%s" data-id_guia_s="%s" data-cedula_s="%s" data-nombre_s="%s" data-empresa_s="%s" data-fecha_s="%s" data-numero_s="%s" data-acta_s="%s" data-observacionesd_s="%s" data-placa_s="%s" data-toggle="modal" data-target="#ingresar_mercaderia" title="Actualizar" class="btn btn-success"><i class="fa fa-pencil" aria-hidden="true"></i></a>',
                $id,
                $id,
                $id_guia,
                $cedula,
                $nombre,
                $empresa,
                $fecha,
                $numero,
                $acta,
                $observacionesd,
                $placa,
                $id_guia_s,
                $cedula_s,
                $nombre_s,
                $empresa_s,
                $fecha_s,
                $numero_s,
                $acta_s,
                $observacionesd_s,
                $placa_s
            );

            // Agregar la fila
            $tabla[] = [
                "marca" => $marca,
                "descripcion" => $descripcion,
                "modelo" => $modelo,
                "chasis" => $chasis,
                "motor" => $motor,
                "color" => $color,
                "accion" => $ingresar
            ];
        }
    } else {
        die(json_encode(["error" => "Error en la consulta SQL", "detalles" => mysqli_error($conn)]));
    }
}

// Respuesta JSON
header('Content-Type: application/json; charset=utf-8');
echo json_encode(["data" => $tabla]);
?>
