<?php
session_start();
$id_usuario = $_SESSION['idusuario'];

include("conex.php");

// Asegura UTF-8
mysqli_set_charset($conn, "utf8");

// Consulta usuarios (incluye campo firma)
$consulta = mysqli_query($conn, "
    SELECT u.idusuario, u.usuario, u.email, u.permiso, u.activo, u.firma, b.detalle, r.nombres, r.cargo
    FROM tb_usuario AS u
    INNER JOIN tb_bodega AS b ON b.idbodega = u.id_bodega
    INNER JOIN tb_registro AS r ON r.idregistro = u.id_registro
    WHERE u.condicion = 1 AND r.idregistro <> 1
");

// Mapeo de permisos
$permisos = [
    1 => "Cliente",
    2 => "Coordinador de Marca",
    3 => "Guardia",
    4 => "Operado de Patio",
    5 => "Impronta",
    6 => "Personal OP Lavador",
    7 => "PDS",
    8 => "Personal OP Pintura",
    9 => "Accesorios",
    10 => "Batería",
    11 => "Supervisor de Marca",
    777 => "Administrador"
];

$data = [];

while ($row = mysqli_fetch_array($consulta)) {
    $id_permiso = (int)$row['permiso'];
    $permiso_desc = isset($permisos[$id_permiso]) ? $permisos[$id_permiso] : "Desconocido";
    
    // Mostrar imagen solo si existe ruta
    $firma = '';
    if (!empty($row['firma']) && file_exists($row['firma'])) {
        $firma = '<img src="'.$row['firma'].'" alt="firma" style="width:80px; height:auto;">';
    } else {
        $firma = 'Sin firma';
    }

    // Botón de editar clave
    $editar = '<a id="btnnotifi'.$row['idusuario'].'" data-ideq="'.$row['idusuario'].'" data-toggle="modal" data-target="#editar_valores" title="Cambiar Clave" class="btn btn-warning"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>';

    // Botón de QR
    $qr = '<a href="../../views/pages/qr/usuario_qr.php?itemdai='.$row['idusuario'].'&d='.$row['usuario'].'" data-toggle="tooltip" data-placement="top" title="Generar QR" class="btn btn-info"><i class="fa fa-qrcode" aria-hidden="true"></i></a>';

    // Botón de subir firma
    $firmaBtn = '<button class="btn btn-primary" onclick="mostrarModalFirma('.$row['idusuario'].')" title="Subir Firma"><i class="fa fa-upload"></i></button>';

    // Botón de Activar / Desactivar
    if ($row['activo'] == 1) {
        $estadoBtn = '<button class="btn btn-danger" onclick="cambiarEstadoUsuario('.$row['idusuario'].', 0)" title="Desactivar usuario"><i class="fa fa-ban"></i></button>';
    } else {
        $estadoBtn = '<button class="btn btn-success" onclick="cambiarEstadoUsuario('.$row['idusuario'].', 1)" title="Activar usuario"><i class="fa fa-check"></i></button>';
    }

    $data[] = [
        "usuario" => $row['usuario'],
        "nombre" => $row['nombres'],
        "cargo" => $row['cargo'],
        "email" => $row['email'],
        "permiso" => $permiso_desc,
        "bodega" => $row['detalle'],
        "firma" => $firma,
        "accion" => $editar . ' ' . $qr . ' ' . $estadoBtn . ' ' . $firmaBtn
    ];
}

echo json_encode(["data" => $data]);
?>
