<?php
session_start();
include("conex.php");

// Validar sesión
if (!isset($_SESSION['idusuario'])) {
    echo json_encode(["status" => "error", "message" => "Acceso denegado: Sesión no iniciada."]);
    exit;
}

// Obtener datos del formulario
$idusuario = $_SESSION['idusuario'];
$iddatadai = $_POST['iddatadai'] ?? null;
$id_guia = $_POST['id_guia'] ?? null;
$empresa = $_POST['empresa'] ?? null;
$numero = $_POST['numero'] ?? null;
$placa = $_POST['placa'] ?? null;
$cedula = $_POST['cedula'] ?? null;
$nombre = $_POST['nombre'] ?? null;
$acta = $_POST['acta'] ?? null;
$fecha = $_POST['fecha'] ?? null;
$observacion = $_POST['observacion'] ?? null;

// Validar que los datos requeridos no estén vacíos
if (!$iddatadai || !$id_guia || !$empresa || !$numero || !$placa || !$cedula || !$nombre || !$acta || !$fecha) {
    echo json_encode(["status" => "error", "message" => "Todos los campos son obligatorios."]);
    exit;
}

// Validar formato de fecha
if (!DateTime::createFromFormat('Y-m-d', $fecha)) {
    echo json_encode(["status" => "error", "message" => "Formato de fecha inválido."]);
    exit;
}

// Variables auxiliares
$actividad = "Actualizar guia";
$my_ip = $_SERVER["REMOTE_ADDR"];
date_default_timezone_set('America/Guayaquil');
$fecha_actual = date('Y-m-d');
$time_actual = date('H:i:s');

// Iniciar transacción
mysqli_begin_transaction($conn);

try {
    // Actualizar datos en la tabla `tb_guia`
    $stmt_update = $conn->prepare("
        UPDATE tb_guia
        SET empresa = ?, numero = ?, placa = ?, cedula = ?, nombre = ?, numeroacta = ?, fecha = ?, observacionesd = ?
        WHERE idguia = ?
    ");
    $stmt_update->bind_param("ssssssssi", $empresa, $numero, $placa, $cedula, $nombre, $acta, $fecha, $observacion, $id_guia);
    $stmt_update->execute();

    if ($stmt_update->affected_rows === 0) {
        throw new Exception("No se pudo actualizar la guía. Verifique los datos.");
    }

    // Registrar la auditoría
    $stmt_audit = $conn->prepare("
        INSERT INTO tb_auditoria (fecha, hora, ip, detalle, id_datadai, id_guia, id_usuario)
        VALUES (?, ?, ?, ?, ?, ?, ?)
    ");
    $stmt_audit->bind_param("ssssiii", $fecha_actual, $time_actual, $my_ip, $actividad, $iddatadai, $id_guia, $idusuario);
    $stmt_audit->execute();

    // Confirmar transacción
    mysqli_commit($conn);

    // Respuesta exitosa
    //echo json_encode(["status" => "success", "message" => "Guía actualizada correctamente."]);
} catch (Exception $e) {
    // Revertir cambios en caso de error
    mysqli_rollback($conn);
    echo json_encode(["status" => "error", "message" => $e->getMessage()]);
} finally {
    // Cerrar recursos
    if (isset($stmt_update)) $stmt_update->close();
    if (isset($stmt_audit)) $stmt_audit->close();
    $conn->close();
}
?>
