<?php
session_start();
include("conex.php");

// Validar sesión
if (!isset($_SESSION['idusuario'])) {
    die("Acceso denegado: Sesión no iniciada.");
}

// Obtener datos del formulario
$idusuario = $_SESSION['idusuario'];
$idaudi = $_POST['idaudi'] ?? null;
$usuario = $_POST['usuario'] ?? null;
$idfac = $_POST['idfac'] ?? null;
$usuario_n = $_POST['usuario_n'] ?? null;

// Validar que los datos requeridos no estén vacíos
if (!$idaudi || !$usuario || !$idfac || !$usuario_n ) {
    die("Error: Todos los campos son obligatorios.");
}

// Variables auxiliares
$actividad = "Actualizar usuario factura informativa";
$my_ip = $_SERVER["REMOTE_ADDR"];
date_default_timezone_set('America/Guayaquil');
$fecha_actual = date('Y-m-d');
$time_actual = date('H:i:s');

// Iniciar transacción
mysqli_begin_transaction($conn);

try {
    // Actualizar datos en la tabla `tb_facturainfo`
    $stmt_update = $conn->prepare("
        UPDATE tb_auditoria
        SET id_usuario = ?
        WHERE idauditoria = ?
    ");
    $stmt_update->bind_param("ii", $usuario_n, $idaudi);
    $stmt_update->execute();

    // Registrar la auditoría
    $stmt_audit = $conn->prepare("
        INSERT INTO tb_auditoria (fecha, hora, ip, detalle, id_facturainfo, id_usuario)
        VALUES (?, ?, ?, ?, ?, ?)
    ");
    $stmt_audit->bind_param("ssssii", $fecha_actual, $time_actual, $my_ip, $actividad, $idfac, $idusuario);
    $stmt_audit->execute();

    // Confirmar transacción
    mysqli_commit($conn);

    //echo "Factura informativa actualizada correctamente.";
} catch (Exception $e) {
    // Revertir cambios en caso de error
    mysqli_rollback($conn);
    echo "Error: " . $e->getMessage();
} finally {
    // Cerrar recursos
    if (isset($stmt_update)) $stmt_update->close();
    if (isset($stmt_audit)) $stmt_audit->close();
    $conn->close();
}
?>
