<?php
session_start();
$id_usuario = $_SESSION['idusuario'];
include("conex.php");

// Obtén el ID de la variable GET de manera segura usando una sentencia preparada
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
    // Si el ID no es válido, puedes mostrar un mensaje de error o redirigir a otra página
    die("ID inválido");
}

// Actualiza las columnas 'pds' e 'id_estado' en una sola consulta
$sql = "UPDATE tb_datadai SET pds = 'Sin daño', id_estado = 14 WHERE iddatadai = ?";

// Preparar la consulta usando sentencias preparadas
if ($stmt = mysqli_prepare($conn, $sql)) {
    // Vincular parámetros
    mysqli_stmt_bind_param($stmt, 'i', $id);

    // Ejecutar la consulta
    $result = mysqli_stmt_execute($stmt);

    // Verificar si la consulta fue exitosa y realizar la inserción en el historial
    if ($result) {
        $actividad = "INSPECCION PDS - S/N";
        $my_ip = $_SERVER["REMOTE_ADDR"];
        date_default_timezone_set('America/Guayaquil');
        $fecha_actual = date('Y/m/d');
        $time_actual = date("H:i:s");

        // Consulta preparada para insertar en el historial
        $sql_insert_historial = "INSERT INTO tb_auditoria (fecha, hora, ip, detalle, id_datadai, id_usuario) VALUES (?, ?, ?, ?, ?, ?)";
        if ($stmt_insert_historial = mysqli_prepare($conn, $sql_insert_historial)) {
            mysqli_stmt_bind_param($stmt_insert_historial, 'ssssii', $fecha_actual, $time_actual, $my_ip, $actividad, $id, $id_usuario);
            mysqli_stmt_execute($stmt_insert_historial);
        }
    }

    // Cerrar la sentencia preparada
    mysqli_stmt_close($stmt);
}

// Redireccionar a la página deseada
//header("Location: ../../views/pages/pds_simple.php");
//exit();
?>


<!DOCTYPE html>
<html>
	<head>
		<meta http-equiv="refresh" content="0;url=../../views/pages/inspeccionpds.php">
		<title>SGO</title>
		<link rel="shortcut icon" href="../../resources/img/icon.ico">
		<script language="javascript">
			
			history.back();
		</script>
	</head>
	<body>
		Go to <a href="../../views/pages/marca.php">../../views/pages/inspeccionpds.php</a>
	</body>
</html>

