<?php
// views/pages/programar.php — Programación de transporte (tb_asignar)
session_start();
if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') {
  header("Location: ../../views/index.php"); exit();
}
$usuario = $_SESSION['usuario'] ?? '';
$permiso = (int)($_SESSION['permiso'] ?? 0);
require_once __DIR__ . '/conex.php';

// Ruta base ABSOLUTA para evitar 404 (ajústala a tu instalación):
$BASE = '/latkic_2.0/views/pages';
$API_LIST   = $BASE . '/api/dai_programar.php';
$API_SAVE   = $BASE . '/controllers/actualizar_gestion.php';
$API_TRACK  = $BASE . '/controllers/guardar_rastreo.php';
$API_LOOKUP = $BASE . '/controllers/buscar_conductor.php';
?>
<?php include __DIR__.'/partials/header.php'; ?>

<style>
  #asigna { font-size: 12px; }
  #asigna thead th { font-size: 12px; }
  #asigna tbody td { font-size: 11px; }
  .tabla-preview { font-size: 9px; width: 90%; table-layout: auto; }
  .tabla-preview th, .tabla-preview td { white-space: nowrap; padding: 4px 8px; vertical-align: middle; }
</style>

<body>
<div class="container-fluid">
  <div class="row">
    <?php include __DIR__.'/partials/menu.php'; ?>

    <main class="col-md-9 ms-sm-auto col-lg-10 px-0">
      <?php include __DIR__.'/partials/topbar.php'; ?>

      <div class="row px-3">
        <div class="col-12">
          <div class="card mt-2">
            <div class="card-body">
              <div class="d-flex justify-content-between align-items-center mb-2">
                <h6 class="mb-0"><i class="fa fa-truck me-2"></i>Programación de Transporte</h6>
                <button id="btnAsignarTransporte" class="btn btn-primary btn-sm" disabled>
                  <i class="fa fa-plus-circle"></i> Asignar Transporte
                </button>
              </div>

              <div class="table-responsive">
                <table id="asigna" class="table table-hover w-100">
                  <thead>
                    <tr class="table-info">
                      <th class="text-center"><input type="checkbox" id="checkAll" style="width:18px;height:18px;"></th>
                      <th>Tipo</th>
                      <th>Agrup M</th>
                      <th>Chasis</th>
                      <th>Color</th>
                      <th>Modelo</th>
                      <th>Marca</th>
                      <th>Pedido</th>
                      <th>Localidad</th>
                      <th>Destino</th>
                      <th>Transportista</th>
                      <th>Placa</th>
                      <th>Conductor</th>
                      <th>Cédula</th>
                      <th>Fecha Carga</th>
                      <th>Fecha Descarga</th>
                      <th>Status</th>
                      <th>Guía</th>
                      <th>Enlace de Rastreo</th>
                      <th>Acción</th>
                    </tr>
                  </thead>
                  <tbody></tbody>
                </table>
              </div>

            </div>
          </div>
        </div>
      </div>
    </main>
  </div>
</div>

<?php include __DIR__.'/partials/footer.php'; ?>

<!-- MODAL ASIGNAR TRANSPORTE -->
<div class="modal fade" id="modalAsignar" tabindex="-1" aria-labelledby="modalAsignarLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <form id="formAsignar" autocomplete="off">
        <div class="modal-header py-2">
          <h6 class="modal-title" id="modalAsignarLabel">Asignar Transporte a Vehículos Seleccionados</h6>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        </div>

        <div class="modal-body">
          <div class="row">
            <div class="col-md-6 mb-2">
              <label class="form-label">Tipo de Transporte *</label>
              <select id="tipo_transporte" class="form-select form-select-sm" required>
                <option value="">Seleccione...</option>
                <option value="Niñera">Niñera</option>
                <option value="Plataforma">Plataforma</option>
                <option value="Grúa">Grúa</option>
                <option value="Rodamiento">Rodamiento</option>
              </select>
            </div>
            <div class="col-md-3 mb-2">
              <label class="form-label">Grupo Movimiento *</label>
              <input type="text" id="agrup_movimiento" class="form-control form-control-sm" required>
            </div>
            <div class="col-md-3 mb-2">
              <label class="form-label">Placa *</label>
              <input type="text" id="placa" class="form-control form-control-sm" placeholder="ABC1234" required>
            </div>
          </div>

          <div class="row">
            <div class="col-md-3 mb-2">
              <label class="form-label">Cédula/Pasaporte</label>
              <input type="text" id="cedula" class="form-control form-control-sm" pattern="[A-Za-z0-9]{5,15}">
            </div>
            <div class="col-md-9 mb-2">
              <label class="form-label">Apellidos y Nombres Conductor *</label>
              <input type="text" id="nombre" class="form-control form-control-sm" required>
            </div>
          </div>

          <div class="row">
            <div class="col-md-6 mb-2">
              <label class="form-label">Fecha y Hora de Carga *</label>
              <input type="datetime-local" id="fecha_carga" class="form-control form-control-sm" required>
            </div>
            <div class="col-md-6 mb-2">
              <label class="form-label">Fecha y Hora de Descarga *</label>
              <input type="datetime-local" id="fecha_descarga" class="form-control form-control-sm" required>
            </div>
          </div>

          <div class="row">
            <div class="col-md-3 mb-2">
              <label class="form-label">Número de Guía</label>
              <input type="text" id="guias" class="form-control form-control-sm">
            </div>
            <div class="col-md-9 mb-2">
              <label class="form-label">Enlace de Rastreo</label>
              <input type="url" id="links" class="form-control form-control-sm" placeholder="https://...">
            </div>
          </div>

          <div class="mb-2">
            <label class="form-label">
              Vehículos Seleccionados:
              <span class="badge bg-primary"><span id="contadorVehiculos">0</span></span>
            </label>
            <div class="table-responsive">
              <table class="table table-sm table-bordered" id="listaChasis">
                <thead class="table-light">
                  <tr>
                    <th>Chasis</th>
                    <th>Color</th>
                    <th>Modelo</th>
                    <th>Marca</th>
                    <th class="text-center">Acción</th>
                  </tr>
                </thead>
                <tbody></tbody>
              </table>
            </div>
          </div>
        </div>

        <div class="modal-footer justify-content-between py-2">
          <button type="button" id="btnVaciarLista" class="btn btn-outline-danger btn-sm">
            <i class="fa fa-trash"></i> Vaciar lista
          </button>
          <div>
            <button type="submit" class="btn btn-success btn-sm">
              <i class="fa fa-save"></i> Guardar Asignación
            </button>
            <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Cancelar</button>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- MODAL RASTREO -->
<div class="modal fade" id="modalRastreo" tabindex="-1" aria-labelledby="modalRastreoLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form id="formRastreo">
        <div class="modal-header py-2">
          <h6 class="modal-title" id="modalRastreoLabel">Datos de Rastreo del Transporte</h6>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" id="rastreo_id_gestion">
          <div class="mb-2">
            <label class="form-label">Número de Guía</label>
            <input type="text" id="guia" class="form-control form-control-sm" required>
          </div>
          <div class="mb-2">
            <label class="form-label">Enlace de Rastreo</label>
            <input type="url" id="enlace" class="form-control form-control-sm" placeholder="https://..." required>
          </div>
        </div>
        <div class="modal-footer py-2">
          <button type="submit" class="btn btn-success btn-sm"><i class="fa fa-save"></i> Guardar</button>
          <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Cancelar</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
$.fn.dataTable.ext.errMode = 'none';
let table;

$(function () {
  // ===== DataTable =====
  table = $('#asigna').DataTable({
    ajax: {
      url: '<?= $API_LIST ?>',
      dataSrc: 'data',
      error: function (xhr) {
        let msg = 'Error cargando datos.';
        try { const j = JSON.parse(xhr.responseText); if (j.message) msg = j.message; } catch(e){}
        console.error('DT AJAX error:', xhr.status, xhr.responseText);
        Swal.fire('Error', msg, 'error');
      }
    },
    columns: [
      { data: 'check', orderable: false, className: 'text-center' },
      { data: 'tipo' },{ data: 'grupo' },{ data: 'chasis' },{ data: 'color' },
      { data: 'modelo' },{ data: 'marca' },{ data: 'pedido' },{ data: 'localidad' },
      { data: 'destino' },{ data: 'transportista' },{ data: 'placa' },{ data: 'conductor' },
      { data: 'cedula' },{ data: 'carga' },{ data: 'descarga' },{ data: 'status' },
      { data: 'guia' },{ data: 'link' },{ data: 'accion', orderable:false, className:'text-center' }
    ],
    columnDefs: [{ targets: '_all', defaultContent: '' }],
    dom: '<"top d-flex align-items-center gap-2"Bf>rt<"bottom d-flex justify-content-between align-items-center"lip>',
    lengthMenu: [[10,25,50,100,-1],[10,25,50,100,"Todos"]],
    buttons: [
      'copy', 'excel',
      { extend:'pdfHtml5', text:'PDF', orientation:'landscape', pageSize:'A4',
        exportOptions:{ columns:':visible' },
        customize: function (doc) {
          doc.styles.tableHeader = { bold:true, fontSize:10, color:'black', fillColor:'#cccccc', alignment:'center' };
          doc.defaultStyle.fontSize = 9;
          if (doc.content && doc.content[1] && doc.content[1].table) {
            doc.content[1].table.widths = Array(doc.content[1].table.body[0].length).fill('*');
          }
        }
      }
    ],
    language: { url: '../../resources/js/es-ES.json' }
  });

  // ===== Helpers =====
  function countChecked(){ return table.$('.check-row:checked').length; }
  function toggleBtn(){ $('#btnAsignarTransporte').prop('disabled', countChecked() === 0); }
  function toDateTimeLocal(v){ return v ? v.replace('T',' ').trim() : ''; }
  function isValidRange(a,b){ if(!a||!b) return false; return new Date(b) >= new Date(a); }

  table.on('draw', function(){ $('#checkAll').prop('checked', false); toggleBtn(); });

  $(document).on('change','#checkAll',function(){
    const on = this.checked; table.$('.check-row').prop('checked', on); toggleBtn();
  });
  $(document).on('change','.check-row',function(){ if(!this.checked) $('#checkAll').prop('checked', false); toggleBtn(); });

  // ===== Abrir modal: cargar SOLO seleccionados a #listaChasis =====
  $('#btnAsignarTransporte').on('click', function(){
    const cuerpo = $('#listaChasis tbody').empty();
    table.$('.check-row:checked').each(function(){
      const $cb=$(this);
      const id=$cb.val(), chasis=$cb.data('chasis')||'', color=$cb.data('color')||'';
      const modelo=$cb.data('modelo')||'', marca=$cb.data('marca')||'';
      cuerpo.append(
        `<tr data-id="${id}">
           <td>${chasis}</td><td>${color}</td><td>${modelo}</td><td>${marca}</td>
           <td class="text-center"><button type="button" class="btn btn-danger btn-sm btn-eliminar"><i class="fa fa-trash"></i></button></td>
         </tr>`
      );
    });
    actualizarContadorVehiculos();
    $('#modalAsignar').modal('show');
  });

  // Eliminar fila del modal
  $(document).on('click','.btn-eliminar', function(){ $(this).closest('tr').remove(); actualizarContadorVehiculos(); });

  function actualizarContadorVehiculos(){
    const n = $('#listaChasis tbody tr').length;
    $('#contadorVehiculos').text(n);
    $('#formAsignar button[type="submit"]').prop('disabled', n===0);
  }

  // ===== Guardar SOLO lo del modal =====
  $('#formAsignar').on('submit', function (e) {
    e.preventDefault();

    const ids = [];
    $('#listaChasis tbody tr').each(function(){ const id=$(this).data('id'); if (id) ids.push(String(id)); });
    if (ids.length===0) { Swal.fire('Atención','No hay vehículos en la lista.','warning'); return; }

    const tipo_transporte   = ($('#tipo_transporte').val() || '').trim();
    const agrup_movimiento  = ($('#agrup_movimiento').val() || '').trim();
    const placa             = ($('#placa').val() || '').trim();
    const cedula            = ($('#cedula').val() || '').trim();
    const nombre            = ($('#nombre').val() || '').trim();
    const fcVal             = $('#fecha_carga').val();
    const fdVal             = $('#fecha_descarga').val();
    const guias             = ($('#guias').val() || '').trim();
    const links             = ($('#links').val() || '').trim();

    if (!tipo_transporte || !agrup_movimiento || !placa || !nombre || !fcVal || !fdVal) {
      Swal.fire('Atención', 'Complete los campos requeridos.', 'warning'); return;
    }
    if (!isValidRange(fcVal, fdVal)) {
      Swal.fire('Atención', 'La fecha de descarga no puede ser anterior a la de carga.', 'warning'); return;
    }

    const payload = {
      ids,
      tipo_transporte,
      agrup_movimiento,
      placa,
      cedula,
      nombre,
      fecha_carga: toDateTimeLocal(fcVal),
      fecha_descarga: toDateTimeLocal(fdVal),
      guias,
      links
    };

    fetch('<?= $API_SAVE ?>', {
      method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify(payload)
    })
    .then(async res => {
      const txt = await res.text(); let json;
      try { json = JSON.parse(txt); } 
      catch(e){ console.error('Respuesta no-JSON:', txt); throw new Error('El servidor devolvió HTML/Texto en vez de JSON.'); }
      if (!res.ok || json.success === false) throw new Error(json.message || `HTTP ${res.status}`);
      return json;
    })
    .then(data => {
      Swal.fire({ icon:'success', title:'Guardado', html:data.message || 'Asignaciones actualizadas.' });
      $('#modalAsignar').modal('hide'); $('#formAsignar')[0].reset();
      $('#listaChasis tbody').empty(); $('#contadorVehiculos').text('0');
      $('#checkAll').prop('checked', false); $('#btnAsignarTransporte').prop('disabled', true);
      table.ajax.reload(null,false);
    })
    .catch(err => { console.error(err); Swal.fire('Error', err.message || 'Error en la conexión.', 'error'); });
  });

  // Opcional: buscar conductor por cédula
  $(document).on('blur','#cedula', function () {
    const ced = ($(this).val()||'').trim(); if (!ced) return;
    fetch('<?= $API_LOOKUP ?>', {
      method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify({ cedula: ced })
    }).then(r=>r.json()).then(d=>{ if(d.success){ $('#nombre').val(d.nombre||''); } }).catch(()=>{});
  });

  // Rastreo
  $(document).on('click','.btn-rastreo', function(){
    $('#rastreo_id_gestion').val($(this).data('id')||'');
    $('#guia').val(''); $('#enlace').val('');
    $('#modalRastreo').modal('show');
  });
  $('#formRastreo').on('submit', function(e){
    e.preventDefault();
    const id=($('#rastreo_id_gestion').val()||'').trim();
    const guia=($('#guia').val()||'').trim();
    const enlace=($('#enlace').val()||'').trim();
    if(!id||!guia||!enlace){ Swal.fire('Atención','Todos los campos son obligatorios.','warning'); return; }
    fetch('<?= $API_TRACK ?>', {
      method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify({ id_gestion:id, guia, enlace })
    }).then(r=>r.json()).then(d=>{
      if(d.success){ Swal.fire('Éxito','Datos guardados.','success'); $('#modalRastreo').modal('hide'); table.ajax.reload(null,false); }
      else { Swal.fire('Error', d.message || 'No se pudo guardar.','error'); }
    }).catch(()=>{ Swal.fire('Error','Fallo en la conexión.','error'); });
  });

});
</script>
</body>
</html>
