<?php
// pdf/index.php — Tarja Entrega-Recepción Vehicular (FPDF) — LISTO PARA PEGAR

declare(strict_types=1);

require_once __DIR__ . '/../conex.php';
require 'fpdf/fpdf.php';

date_default_timezone_set('America/Guayaquil');

/* ==== Diagnóstico MySQLi recomendado ==== */
if (function_exists('mysqli_report')) {
  mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
}

/* ====== INPUT ====== */
$iddatadai = isset($_GET['id']) ? (int)$_GET['id'] : (int)($_GET['itemdai'] ?? 0);
if ($iddatadai <= 0) {
  http_response_code(400);
  exit('ID inválido');
}

/* ====== VARIABLES BASE (evitar Undefined) ====== */
$contador = 0;
$fecha_actual  = date('Y/m/d');
$fecha_actual2 = date('d/m/Y');

$id_guia2 = 0;
$placa = $empresa = $numero = $cedula = $nombre = $fechaguia = $numeroacta = '';
$placa2 = $empresa2 = $numero2 = $cedula2 = $nombre2 = $observacionesd2 = '';

$tipodai = $marca = $modelo = $chasis = $motor = $color = '';
$razon_social = '';
$impronta = $pds = '';

$nro_manual = $siglas = '';
$numero_auto = 0;
$numerotarja = '';
$fechatarja = '';
$observacion = '';
$fecha_salida = '';

$coor_cedula = $coor_nombres = $coor_firma = '';
$nombretarja = '';
$idbodega = 0;

/* Marcadores de SI/NO inicializados */
$aes1=$aen1=$aes2=$aen2=$aes3=$aen3=$aes4=$aen4=$aes5=$aen5=$aes6=$aen6=$aes7=$aen7=$aes8=$aen8=$aes9=$aen9=$aes10=$aen10=$aes11=$aen11=$aes12=$aen12=$aes13=$aen13='';
$ais1=$ain1=$ais2=$ain2=$ais3=$ain3=$ais4=$ain4=$ais5=$ain5=$ais6=$ain6=$ais7=$ain7=$ais8=$ain8=$ais9=$ain9=$ais10=$ain10=$ais11=$ain11=$ais12=$ain12=$ais13=$ain13=$ais14=$ain14='';
$ae14 = $ae15 = 0;

/* ====== 1) PERSONA QUE INSPECCIONÓ (desde tarja.id_inspeccion) ====== */
$stmt = $conn->prepare("
  SELECT r.nombres
  FROM tb_tarja AS t
  INNER JOIN tb_usuario u ON u.idusuario = t.id_inspeccion
  INNER JOIN tb_registro r ON r.idregistro = u.id_registro
  WHERE t.id_datadai = ?
  ORDER BY t.idtarja DESC
  LIMIT 1
");
$stmt->bind_param("i", $iddatadai);
$stmt->execute();
$res = $stmt->get_result();
if ($row = $res->fetch_assoc()) {
  $nombretarja = $row['nombres'] ?? '';
}
$stmt->close();

/* ====== 2) COORDINADOR (según tu esquema actual: id_inspeccion) ====== */
$stmt = $conn->prepare("
  SELECT r.cedula, r.nombres, u.firma
  FROM tb_tarja AS t
  INNER JOIN tb_usuario u ON u.idusuario = t.id_inspeccion
  INNER JOIN tb_registro r ON r.idregistro = u.id_registro
  WHERE t.condicion = 1 AND t.id_datadai = ?
  ORDER BY t.numero_auto DESC, t.idtarja DESC
  LIMIT 1
");
$stmt->bind_param("i", $iddatadai);
$stmt->execute();
$res = $stmt->get_result();
if ($row = $res->fetch_assoc()) {
  $coor_cedula  = $row['cedula']  ?? '';
  $coor_nombres = $row['nombres'] ?? '';
  $coor_firma   = $row['firma']   ?? '';
}
$stmt->close();

/* ====== 3) GUÍAS (ingreso y despacho) ====== */
$q = "
  SELECT a.placa, t.nombre, a.guia, a.numero_doc, a.conductor, a.fecha 
  FROM tb_asignar a
  INNER JOIN tb_transporte t ON t.id = a.transportista
  INNER JOIN tb_asignar_datadai ad ON ad.id_asignar = a.id
  INNER JOIN tb_datadai d ON d.iddatadai = ad.id_datadai
  WHERE a.condicion = 1 AND d.iddatadai = {$iddatadai}
  LIMIT 1
";
if ($rs = mysqli_query($conn, $q)) {
  if ($row = mysqli_fetch_assoc($rs)) {
    $placa      = $row['placa'] ?? '';
    $empresa    = $row['nombre'] ?? '';
    $numero     = $row['guia'] ?? '';
    $cedula     = $row['numero_doc'] ?? '';
    $nombre     = $row['conductor'] ?? '';
    $fechaguia  = $row['fecha'] ?? '';
    $numeroacta = '';
  }
  mysqli_free_result($rs);
}

$q = "
  SELECT a.placa, t.nombre, a.guia, a.numero_doc, a.conductor, d.id_guia2, ob.recibido, ob.descripcion
  FROM tb_asignar a
  INNER JOIN tb_transporte t ON t.id = a.transportista
  INNER JOIN tb_datadai AS d ON d.id_guia2 = a.id
  LEFT JOIN tb_observaciones AS ob ON ob.id_datadai = d.iddatadai
  WHERE (ob.despacho = 1 OR a.condicion = 1) AND d.iddatadai = {$iddatadai}
  LIMIT 1
";
if ($rs = mysqli_query($conn, $q)) {
  if ($row = mysqli_fetch_assoc($rs)) {
    $id_guia2         = (int)($row['id_guia2'] ?? 0);
    $placa2           = $row['placa'] ?? '';
    $empresa2         = $row['nombre'] ?? '';
    $numero2          = $row['guia'] ?? '';
    $cedula2          = $row['numero_doc'] ?? '';
    $nombre2          = $row['conductor'] ?? '';
    $observacionesd2  = $row['descripcion'] ?? '';
  }
  mysqli_free_result($rs);
}

/* ====== 4) BODEGA por la DAI de la unidad ====== */
$q = "
  SELECT b.sigla, b.idbodega
  FROM tb_bodega AS b
  INNER JOIN tb_daientrada AS daie ON daie.id_bodega = b.idbodega
  INNER JOIN tb_datadai  AS dai  ON dai.id_daientrada = daie.iddaientrada
  WHERE dai.iddatadai = {$iddatadai} AND dai.condicion = 1
  LIMIT 1
";
if ($rs = mysqli_query($conn, $q)) {
  if ($row = mysqli_fetch_assoc($rs)) {
    $idbodega = (int)($row['idbodega'] ?? 0);
    $siglas   = $row['sigla'] ?? '';
  }
  mysqli_free_result($rs);
}

/* ====== 5) DATOS DE LA UNIDAD / CLIENTE ====== */
$q = "
  SELECT d.dai, d.marca, d.modelo, d.chasis, d.motor, d.color, d.impronta, d.pds, e.razon_social
  FROM tb_datadai  AS d
  INNER JOIN tb_solicitudprevia AS sp ON sp.idsolicitudprevia = d.id_solicitudprevia
  INNER JOIN tb_empresa        AS e  ON e.idempresa = sp.id_empresa
  WHERE d.iddatadai = {$iddatadai} AND d.condicion = 1
  LIMIT 1
";
if ($rs = mysqli_query($conn, $q)) {
  if ($row = mysqli_fetch_assoc($rs)) {
    $tipodai       = $row['dai'] ?? '';
    $marca         = $row['marca'] ?? '';
    $modelo        = $row['modelo'] ?? '';
    $chasis        = $row['chasis'] ?? '';
    $motor         = $row['motor'] ?? '';
    // FPDF usa ISO-8859-1; si tus datos están en UTF-8, decodificar:
    $color         = utf8_decode($row['color'] ?? '');
    $razon_social  = $row['razon_social'] ?? '';
    $impronta      = $row['impronta'] ?? '';
    $pds           = $row['pds'] ?? '';
  }
  mysqli_free_result($rs);
}

$dap    = ($tipodai === 'Simple') ? '' : 'X'; // (no usado visualmente, lo dejo por si lo necesitas)
$simple = ($tipodai === 'Simple') ? 'X' : '';

/* ====== 6) ÚLTIMA TARJA de la unidad ====== */
$q = "
  SELECT *
  FROM tb_tarja
  WHERE id_datadai = {$iddatadai} AND condicion = 1
  ORDER BY numero_auto DESC, idtarja DESC
  LIMIT 1
";
if ($rs = mysqli_query($conn, $q)) {
  if ($row = mysqli_fetch_assoc($rs)) {
    $nro_manual   = $row['nro_manual'] ?? '';
    $siglas       = $row['siglas'] ?? ($siglas ?? '');
    $numero_auto  = (int)($row['numero_auto'] ?? 0);
    $numerotarja  = $row['numerotarja'] ?? '';
    $fechatarja   = $row['fechatarja'] ?? '';
    $observacion  = $row['observacion'] ?? '';
    $fecha_salida = $row['fecha_salida'] ?? '';

    // Accesorios exterior (ae1..ae13) e interior (ai1..ai14)
    $aes1 = ($row['ae1']  ?? 0) ? 'X' : '';  $aen1 = $aes1 ? '' : 'X';
    $aes2 = ($row['ae2']  ?? 0) ? 'X' : '';  $aen2 = $aes2 ? '' : 'X';
    $aes3 = ($row['ae3']  ?? 0) ? 'X' : '';  $aen3 = $aes3 ? '' : 'X';
    $aes4 = ($row['ae4']  ?? 0) ? 'X' : '';  $aen4 = $aes4 ? '' : 'X';
    $aes5 = ($row['ae5']  ?? 0) ? 'X' : '';  $aen5 = $aes5 ? '' : 'X';
    $aes6 = ($row['ae6']  ?? 0) ? 'X' : '';  $aen6 = $aes6 ? '' : 'X';
    $aes7 = ($row['ae7']  ?? 0) ? 'X' : '';  $aen7 = $aes7 ? '' : 'X';
    $aes8 = ($row['ae8']  ?? 0) ? 'X' : '';  $aen8 = $aes8 ? '' : 'X';
    $aes9 = ($row['ae9']  ?? 0) ? 'X' : '';  $aen9 = $aes9 ? '' : 'X';
    $aes10= ($row['ae10'] ?? 0) ? 'X' : '';  $aen10= $aes10? '' : 'X';
    $aes11= ($row['ae11'] ?? 0) ? 'X' : '';  $aen11= $aes11? '' : 'X';
    $aes12= ($row['ae12'] ?? 0) ? 'X' : '';  $aen12= $aes12? '' : 'X';
    $aes13= ($row['ae13'] ?? 0) ? 'X' : '';  $aen13= $aes13? '' : 'X';

    $ais1  = ($row['ai1']  ?? 0) ? 'X' : ''; $ain1  = $ais1  ? '' : 'X';
    $ais2  = ($row['ai2']  ?? 0) ? 'X' : ''; $ain2  = $ais2  ? '' : 'X';
    $ais3  = ($row['ai3']  ?? 0) ? 'X' : ''; $ain3  = $ais3  ? '' : 'X';
    $ais4  = ($row['ai4']  ?? 0) ? 'X' : ''; $ain4  = $ais4  ? '' : 'X';
    $ais5  = ($row['ai5']  ?? 0) ? 'X' : ''; $ain5  = $ais5  ? '' : 'X';
    $ais6  = ($row['ai6']  ?? 0) ? 'X' : ''; $ain6  = $ais6  ? '' : 'X';
    $ais7  = ($row['ai7']  ?? 0) ? 'X' : ''; $ain7  = $ais7  ? '' : 'X';
    $ais8  = ($row['ai8']  ?? 0) ? 'X' : ''; $ain8  = $ais8  ? '' : 'X';
    $ais9  = ($row['ai9']  ?? 0) ? 'X' : ''; $ain9  = $ais9  ? '' : 'X';
    $ais10 = ($row['ai10'] ?? 0) ? 'X' : ''; $ain10 = $ais10 ? '' : 'X';
    $ais11 = ($row['ai11'] ?? 0) ? 'X' : ''; $ain11 = $ais11 ? '' : 'X';
    $ais12 = ($row['ai12'] ?? 0) ? 'X' : ''; $ain12 = $ais12 ? '' : 'X';
    $ais13 = ($row['ai13'] ?? 0) ? 'X' : ''; $ain13 = $ais13 ? '' : 'X';
    $ais14 = ($row['ai14'] ?? 0) ? 'X' : ''; $ain14 = $ais14 ? '' : 'X';

    $ae14  = (int)($row['ae14'] ?? 0);
    $ae15  = (int)($row['ae15'] ?? 0);
  }
  mysqli_free_result($rs);
}

/* ====== PDF ====== */
$pdf = new FPDF('P', 'mm', 'A4');
$pdf->AliasNbPages();
$pdf->AddPage();

$pdf->SetFont('Arial','B',14);
$pdf->SetY(10);
$pdf->Cell(0,25,"",1,2,'C');
$pdf->Cell(0,-40,utf8_decode("TARJA ENTREGA-RECEPCIÓN VEHÍCULAR"),0,2,'C');
if (file_exists(__DIR__.'/img/latkic.png')) {
  $pdf->Image(__DIR__.'/img/latkic.png', 11, 11, 40, 20, 'PNG');
}

/* Nro formateado */
$numero_formateado = ($siglas ?: '').str_pad((string)$numero_auto, 4, '0', STR_PAD_LEFT);
$pdf->SetFont('Arial','B',18);
$pdf->SetY(25);
$pdf->Cell(0,0,utf8_decode("Nro.: ".$numero_formateado),0,1,'R');

/* Nro. Referencial (numerotarja si existe) */
/*if (!empty($numerotarja)) {
  $pdf->SetFont('Arial','B',12);
  $pdf->SetY(30);
  $pdf->Cell(0,0,utf8_decode("Nro. Referencial: ".$numerotarja),0,1,'R');
}*/

/* Código SGI según fecha de tarja */
$fecha_corte = '2023-11-09';
$pdf->SetFont('Arial','',8);
$pdf->SetY(32);
if (!empty($fechatarja) && $fechatarja > $fecha_corte) {
  $pdf->Cell(0,2,utf8_decode("Código SGI: LATKIC-OP-RF00020 /Rev.#00 /10-11-2023"),0,1,'L');
} else {
  $pdf->Cell(0,2,utf8_decode("Código SGI: LATKIC-OP-RF00002/Rev.#00/01-04-2023"),0,1,'L');
}

/* Cliente / Fechas */
$pdf->SetFont('Arial','',10);
$pdf->SetY(35);
$pdf->Cell(100,16,"",1,1,'L');

$pdf->SetY(38);
$pdf->Cell(0,2,utf8_decode("CLIENTE:"),0,1,'L');
$pdf->SetY(45);
$pdf->Cell(0,2,utf8_decode($razon_social),0,1,'L');

$pdf->SetY(35);
$pdf->SetX(110);
$pdf->Cell(45,16,"",1,1,'R');
$pdf->SetY(38);
$pdf->SetX(111);
$pdf->Cell(0,2,utf8_decode("FECHA DE INGRESO:"),0,1,'L');
$pdf->SetY(45);
$pdf->SetX(120);
$pdf->Cell(0,2,utf8_decode($fechaguia ?? ''),0,1,'L');

$pdf->SetY(35);
$pdf->SetX(155);
$pdf->Cell(45,16,"",1,1,'R');
$pdf->SetY(38);
$pdf->SetX(156);
$pdf->Cell(0,2,utf8_decode("FECHA DE SALIDA:"),0,1,'L');
$pdf->SetY(45);
$pdf->SetX(165);
$pdf->Cell(0,2,utf8_decode($fecha_salida ?? ''),0,1,'L');

/* Descripción vehículo */
$pdf->SetFont('Arial','B',12);
$pdf->SetY(51);
$pdf->Cell(0,5,utf8_decode("DESCRIPCIÓN DEL VEHÍCULO"),1,2,'C');

$pdf->SetFont('Arial','',8);
$pdf->SetY(56);
$pdf->Cell(55,5,utf8_decode("MARCA: ".$marca),1,2,'L');

$pdf->SetY(56);
$pdf->SetX(65);
$pdf->Cell(135,5,utf8_decode("MODELO: ".$modelo),1,2,'L');

$pdf->SetY(61);
$pdf->Cell(55,5,utf8_decode("CHASIS: ".$chasis),1,2,'L');

$pdf->SetY(61);
$pdf->SetX(65);
$pdf->Cell(70,5,utf8_decode("MOTOR: ".$motor),1,2,'L');

$pdf->SetY(61);
$pdf->SetX(135);
$pdf->Cell(65,5,utf8_decode("COLOR: ".$color),1,2,'L');

$pdf->SetY(66);
$pdf->Cell(55,5,utf8_decode("IMPRONTA: ".$impronta),1,2,'L');

$pdf->SetY(66);
$pdf->SetX(65);
$pdf->Cell(135,5,utf8_decode("PDS: ".$pds),1,2,'L');

/* Condiciones */
$pdf->SetFont('Arial','B',12);
$pdf->SetY(71);
$pdf->Cell(0,6,utf8_decode("CONDICIONES DEL VEHÍCULO"),1,2,'C');

$pdf->SetFont('Arial','B',10);
$pdf->SetY(77);
$pdf->Cell(65,5,utf8_decode("ACCESORIOS EXTERIOR"),1,2,'C');
$pdf->SetY(77); $pdf->SetX(75);  $pdf->Cell(15,5,"SI",1,2,'C');
$pdf->SetY(77); $pdf->SetX(90);  $pdf->Cell(15,5,"NO",1,2,'C');

$pdf->SetY(77); $pdf->SetX(105); $pdf->Cell(65,5,utf8_decode("ACCESORIOS INTERIOR"),1,2,'C');
$pdf->SetY(77); $pdf->SetX(170); $pdf->Cell(15,5,"SI",1,2,'C');
$pdf->SetY(77); $pdf->SetX(185); $pdf->Cell(15,5,"NO",1,2,'C');

$pdf->SetFont('Arial','',10);

/* Fila por fila */
$rows = [
  ["BATERIA",             $aes1,$aen1,  "ENCENDEDOR",            $ais1,$ain1],
  ["TAPAS MOTOR FLUIDOS", $aes2,$aen2,  "CENICERO",              $ais2,$ain2],
  ["PLUMAS Y CAUCHOS",    $aes3,$aen3,  "MANUALES",              $ais3,$ain3],
  ["ANTENA",              $aes4,$aen4,  "MOLDURAS",              $ais4,$ain4],
  ["MANIJAS EXTERIOR",    $aes5,$aen5,  "ALFOMBRA Y MOQUETAS",   $ais5,$ain5],
  ["TAPA DE COMBUSTIBLE", $aes6,$aen6,  "TRIANGULO",             $ais6,$ain6],
  ["EMBLEMAS",            $aes7,$aen7,  "EXTINTOR",              $ais7,$ain7],
  ["LLANTAS DE EMERGENCIA",$aes8,$aen8, "CARTON SELLADO",        $ais8,$ain8],
  ["TAPA CUBOS",          $aes9,$aen9,  "RADIO Y PARLANTES",     $ais9,$ain9],
  ["TAPA VALVULAS",       $aes10,$aen10,"MANIJAS Y PERILLAS",    $ais10,$ain10],
  ["ESPEJOS EXTERIOR",    $aes11,$aen11,"CINTURON DE SEGURIDAD", $ais11,$ain11],
  ["GANCHO DE REMOLQUE",  $aes12,$aen12,"VISERAS",               $ais12,$ain12],
  ["HERRAMIENTAS",        $aes13,$aen13,"ESPEJOS INTERIOR",      $ais13,$ain13],
];
$y = 82;
foreach ($rows as $r) {
  [$l1,$si1,$no1,$l2,$si2,$no2] = $r;
  $pdf->SetY($y);   $pdf->Cell(65,5,utf8_decode($l1),1,2,'L');
  $pdf->SetY($y);   $pdf->SetX(75);  $pdf->Cell(15,5,$si1,1,2,'C');
  $pdf->SetY($y);   $pdf->SetX(90);  $pdf->Cell(15,5,$no1,1,2,'C');

  $pdf->SetY($y);   $pdf->SetX(105); $pdf->Cell(65,5,utf8_decode($l2),1,2,'L');
  $pdf->SetY($y);   $pdf->SetX(170); $pdf->Cell(15,5,$si2,1,2,'C');
  $pdf->SetY($y);   $pdf->SetX(185); $pdf->Cell(15,5,$no2,1,2,'C');
  $y += 5;
}

/* LLAVES/CONTROL + GATA */
$pdf->SetY(147);
$pdf->Cell(65,5,utf8_decode("LLAVES ( ".$ae14." ) CONTROL ( ".$ae15." )"),1,2,'L');
$pdf->SetY(147); $pdf->SetX(75);  $pdf->Cell(15,5,"",1,2,'C');
$pdf->SetY(147); $pdf->SetX(90);  $pdf->Cell(15,5,"",1,2,'C');
$pdf->SetY(147); $pdf->SetX(105); $pdf->Cell(65,5,utf8_decode("GATA Y PALANCA"),1,2,'L');
$pdf->SetY(147); $pdf->SetX(170); $pdf->Cell(15,5,$ais14,1,2,'C');
$pdf->SetY(147); $pdf->SetX(185); $pdf->Cell(15,5,$ain14,1,2,'C');

/* Novedades de ingreso / Abreviaturas */
if (!empty($fechatarja) && $fechatarja > $fecha_corte) {
  $pdf->SetFont('Arial','B',10);
  $pdf->SetY(152); $pdf->Cell(0,6,utf8_decode("NOVEDADES DE INGRESO"),1,2,'C');
} else {
  $pdf->SetFont('Arial','B',10);
  $pdf->SetY(152); $pdf->Cell(0,6,utf8_decode("ABREVIATURAS: (RYS) RAYAS   (DPR) PICADO  (GOL) GOLPE  (FAL) FALTANTE"),1,2,'L');
}

/* Encabezado novedades */
$pdf->SetFont('Arial','',10);
$pdf->SetY(158); $pdf->SetX(10);  $pdf->Cell(60,5,utf8_decode("ZONA"),1,2,'C');
$pdf->SetY(158); $pdf->SetX(70);  $pdf->Cell(60,5,utf8_decode("PARTE"),1,2,'C');
$pdf->SetY(158); $pdf->SetX(130); $pdf->Cell(70,5,utf8_decode("NOVEDAD"),1,2,'C');

$y = 163;

/* ====== 7) INCIDENTES (JOIN corregido a i.id_zona) ====== */
$incide = "
  SELECT z.detallezona, p.detalleparte, n.detallenovedad
  FROM tb_incidente AS i
  LEFT JOIN tb_parte   AS p ON p.idparte   = i.id_parte
  LEFT JOIN tb_zona    AS z ON z.idzona    = i.id_zona
  LEFT JOIN tb_novedad AS n ON n.idnovedad = i.id_novedad
  WHERE i.condicion = 1 AND i.id_datadai = {$iddatadai}
  ORDER BY i.idincidente ASC
";
if ($incidente = mysqli_query($conn, $incide)) {
  while ($row = mysqli_fetch_assoc($incidente)) {
    $pdf->SetY($y); $pdf->SetX(10);
    $pdf->Cell(60,5,utf8_decode($row['detallezona'] ?? ''),1,0,'L',0);
    $pdf->Cell(60,5,utf8_decode($row['detalleparte'] ?? ''),1,0,'L',0);
    $pdf->Cell(70,5,utf8_decode($row['detallenovedad'] ?? ''),1,0,'L',0);
    $y += 5;

    if ($y > 270) {
      $pdf->AddPage();
      // reasignar encabezados si cambias de página
      $pdf->SetFont('Arial','',10);
      $pdf->SetY(10); // margen superior en la nueva página
      $y = 15;
      $pdf->SetY($y); $pdf->SetX(10);  $pdf->Cell(60,5,utf8_decode("ZONA"),1,2,'C');
      $pdf->SetY($y); $pdf->SetX(70);  $pdf->Cell(60,5,utf8_decode("PARTE"),1,2,'C');
      $pdf->SetY($y); $pdf->SetX(130); $pdf->Cell(70,5,utf8_decode("NOVEDAD"),1,2,'C');
      $y += 5;
    }
  }
  mysqli_free_result($incidente);
}

/* Observaciones Recepción */
$pdf->SetFont('Arial','B',10);
$pdf->SetY($y); $pdf->SetX(10);
$pdf->Cell(190,5,utf8_decode("OBSERVACIONES RECEPCIÓN"),1,2,'C');

if ($y > 262) { $pdf->AddPage(); $y = 12; }
if ($y > 257) { $pdf->AddPage(); $y = 12; }

$pdf->SetY($y+5); $pdf->SetX(10);
$pdf->Cell(190,15,"",1,'J',0);
$pdf->SetFont('Arial','',10);
$pdf->SetY($y+5); $pdf->SetX(10);
$pdf->MultiCell(185,5,utf8_decode($observacion ?? ''),0,'J',0);

if ($y > 252) { $pdf->AddPage(); $y = 12; }

/* Persona que inspecciona */
$pdf->SetFont('Arial','B',8);
$pdf->SetY($y+20); $pdf->SetX(10);
$pdf->Cell(60,5,utf8_decode("PERSONA QUE INSPECCIONA EL VH LK:"),1,2,'L');

$pdf->SetFont('Arial','',10);
$pdf->SetY($y+20); $pdf->SetX(70);
$pdf->Cell(130,5,utf8_decode($nombretarja),1,2,'L');

if ($y > 225) { $pdf->AddPage(); $y = 12; }

$y += 25;

/* Observaciones despacho */
$pdf->SetFont('Arial','B',10);
$pdf->SetY($y); $pdf->SetX(10);
$pdf->Cell(190,5,utf8_decode("OBSERVACIONES DESPACHO"),1,2,'C');

$pdf->SetY($y+5); $pdf->SetX(10);
$pdf->SetFont('Arial','',9);
$pdf->MultiCell(190,5,utf8_decode($observacionesd2 ?? ''),0,'J',0);
$pdf->SetY($y+5); $pdf->SetX(10);
$pdf->Cell(190,10,utf8_decode(""),1,'J',0);

if ($y > 230) { $pdf->AddPage(); $y = 12; }

/* Datos del transporte */
$pdf->SetFont('Arial','B',10);
$pdf->SetY($y+15); $pdf->SetX(10);
$pdf->Cell(190,5,utf8_decode("DATOS DEL TRANSPORTE"),1,2,'C');

$pdf->SetFont('Arial','B',10);
$pdf->SetY($y+20); $pdf->SetX(10);
$pdf->Cell(95,5,utf8_decode("RECEPCIÓN BODEGA"),1,2,'C');

$pdf->SetFont('Arial','',8);
$pdf->SetY($y+25); $pdf->SetX(10);
$pdf->Cell(95,5,utf8_decode("NOMBRE: ".$nombre),1,1,'L');

$pdf->SetY($y+30); $pdf->SetX(10);
$pdf->Cell(95,5,utf8_decode("CI: ".$cedula),1,1,'L');

if (!empty($fechatarja) && $fechatarja > $fecha_corte) {
  $pdf->SetY($y+35); $pdf->SetX(10);
  $pdf->Cell(55,5,utf8_decode("PLACA: ".$placa),1,1,'L');

  $pdf->SetY($y+35); $pdf->SetX(65);
  $pdf->Cell(40,5,utf8_decode("ACTA: ".$numeroacta),1,1,'L');
} else {
  $pdf->SetY($y+35); $pdf->SetX(10);
  $pdf->Cell(95,5,utf8_decode("PLACA: ".$placa),1,1,'L');
}

/* Despacho bodega */
$pdf->SetFont('Arial','B',10);
$pdf->SetY($y+20); $pdf->SetX(105);
$pdf->Cell(95,5,utf8_decode("DESPACHO BODEGA"),1,2,'C');

$pdf->SetFont('Arial','',8);
$pdf->SetY($y+25); $pdf->SetX(105);
$pdf->Cell(95,5,utf8_decode("NOMBRE: ".$nombre2),1,1,'L');

$pdf->SetY($y+30); $pdf->SetX(105);
$pdf->Cell(95,5,utf8_decode("CI: ".$cedula2),1,1,'L');

$pdf->SetY($y+35); $pdf->SetX(105);
$pdf->Cell(95,5,utf8_decode("PLACA: ".$placa2),1,1,'L');

/* Inspector externo */
$pdf->SetFont('Arial','B',10);
$pdf->SetY($y+40); $pdf->SetX(10);
$pdf->Cell(190,5,utf8_decode("DATOS DEL INSPECTOR EXTERNO"),1,2,'C');

/* Inspección de despacho */
if ($y > 217) { $pdf->AddPage(); $y = 12; }

$pdf->SetFont('Arial','B',10);
$pdf->SetY($y+45); $pdf->SetX(10);
$pdf->Cell(190,5,utf8_decode("INSPECCIÓN DE DESPACHO"),1,2,'C');

$pdf->SetFont('Arial','',10);
$pdf->SetY($y+50); $pdf->SetX(10);
$pdf->Cell(110,5,utf8_decode("CI: ".$coor_cedula),1,2,'L');

$pdf->SetY($y+55); $pdf->SetX(10);
$pdf->Cell(110,5,utf8_decode("NOMBRES: ".$coor_nombres),1,2,'L');

/* Firma */
$ruta_firma = realpath(__DIR__.'/../views/pages/'.($coor_firma ?? '')) ?: '';
$pdf->SetY($y + 50); $pdf->SetX(120);
$pdf->SetFont('Arial', '', 10);
$pdf->Cell(80, 10, utf8_decode("Firma:"), 1, 2, 'L');

if (!empty($coor_firma) && $ruta_firma && file_exists($ruta_firma)) {
  // (x=135, y=$y+48, ancho=35mm)
  $pdf->Image($ruta_firma, 135, $y + 48, 35, 12);
}

/* Nota */
$pdf->SetFont('Arial','',6);
$pdf->SetY($y+60); $pdf->SetX(10);
$pdf->Cell(190,3,utf8_decode("NOTA: LK BONDED WAREHOUSE NO SE RESPONSABILIZA POR FALTANTES Y DAÑOS PRESENTADOS POSTERIOR A LA ENTREGA DE LAS MERCANCÍAS"),0,2,'L');

$pdf->Output();
