<?php
// partials/topbar.php
date_default_timezone_set('America/Guayaquil');
$fechaHora = date('d/m/Y H:i:s');
?>
<style>
.topbar-custom {
  background-color: #fd0404a9 !important; /* rojo claro */
  color: #f7eeeeff !important;           /* texto rojo oscuro */
}
</style>
<div class="topbar-custom position-sticky top-0 z-3 w-100 bg-dark text-white px-3 py-2 d-flex justify-content-between align-items-center shadow">
  <h1 class="h5 mb-0">
    <i class="fa-solid fa-chart-line fa-lg me-2"></i>SGO.
  </h1>
  <div class="d-flex align-items-center gap-3">
    <span id="reloj"><i class="fa-regular fa-clock me-1"></i> <?= $fechaHora ?></span>
    <span class="badge bg-light text-dark fw-semibold">
      <i class="fa-solid fa-user me-1"></i> <?= htmlspecialchars($_SESSION['usuario']) ?>
    </span>
    <!-- Botón rojo Cerrar Sesión -->
    <form id="logoutForm" action="logout.php" method="post" class="m-0">
      <!-- Botón Cerrar Sesión -->
      <button type="button" id="btnLogout" class="btn btn-sm btn-danger fw-bold d-flex align-items-center" title="Cerrar sesión">
        <i class="fa-solid fa-right-from-bracket me-1"></i> <span>Salir</span>
      </button>
    </form>
  </div>
</div>


<!-- Reloj en vivo -->
<script>
  function actualizarReloj() {
    const reloj = document.getElementById('reloj');
    if (!reloj) return;
    const ahora = new Date();
    const formato = ahora.toLocaleString('es-EC', {
      year: 'numeric',
      month: '2-digit',
      day: '2-digit',
      hour: '2-digit',
      minute: '2-digit',
      second: '2-digit',
      hour12: false
    }).replace(',', '');
    reloj.innerHTML = '<i class="fa-regular fa-clock me-1"></i> ' + formato;
  }
  setInterval(actualizarReloj, 1000);
  actualizarReloj();
</script>

<!-- Confirmación SweetAlert2 para cerrar sesión -->
<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
  document.getElementById('btnLogout').addEventListener('click', function () {
    Swal.fire({
      title: '¿Deseas cerrar sesión?',
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#d33',
      cancelButtonColor: '#3085d6',
      confirmButtonText: 'Sí, cerrar',
      cancelButtonText: 'Cancelar'
    }).then((result) => {
      if (result.isConfirmed) {
        // Mostrar mensaje de despedida
        Swal.fire({
          title: 'Hasta pronto 👋',
          text: 'Cerrando sesión...',
          icon: 'success',
          showConfirmButton: false,
          timer: 1500
        });

        // Redirigir después de la animación
        setTimeout(() => {
          window.location.href = 'logout.php';
        }, 1600);
      }
    });
  });
</script>
