<?php
// index.php — Nacionalizados (BS5 + DataTables, sin modal de Items, stacked modals OK)
session_start();
if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') {
  header("Location: ../../views/index.php"); exit();
}
$usuario = $_SESSION['usuario'] ?? '';
$permiso = $_SESSION['permiso'] ?? '';
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <title>SGO · Nacionalizados</title>

  <!-- Bootstrap 5 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"/>
  <!-- Font Awesome 6 -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet"/>
  <!-- DataTables (DT + Buttons + Responsive) -->
  <link rel="stylesheet"
        href="https://cdn.datatables.net/v/bs5/jszip-3.10.1/dt-1.13.8/b-2.4.2/b-colvis-2.4.2/b-html5-2.4.2/b-print-2.4.2/r-2.5.0/datatables.min.css"/>

  <style>
    :root { --fz: 1.06rem; }
    body { font-size: var(--fz); }
    .table td, .table th { vertical-align: middle; }
    .btn-sm { padding: .25rem .5rem; }
    .modal-header { background:#f6f7fb; }
    table.dataTable tbody tr > * { padding-top:.35rem; padding-bottom:.35rem; }
    .dataTables_wrapper .dt-buttons { margin-bottom:.5rem; }
    .badge-status { font-size: .80rem; }
    .input-inline { max-width: 260px; }

    /* Opcional: eleva el segundo modal sobre el primero (stacked modals) */
    .modal-backdrop.show + .modal,
    .modal-backdrop ~ .modal {
      z-index: 1060;
    }
  </style>
</head>
<body>
<div class="container-fluid">
  <div class="row">
    <!-- Sidebar -->
    <?php include __DIR__ . '/partials/menu.php'; ?>

    <!-- Contenido principal -->
    <main class="col-md-9 ms-sm-auto col-lg-10 px-0">
      <!-- Topbar -->
      <?php include __DIR__ . '/partials/topbar.php'; ?>

      <div class="container-fluid py-2">
        <div class="card shadow-sm">
          <div class="card-header py-2 d-flex align-items-center justify-content-between">
            <div>
              <i class="fa-solid fa-flag-checkered me-2"></i> Nacionalizados
            </div>
            <div class="d-flex gap-2">
              <button class="btn btn-sm btn-success" id="btnAbrirGuia">
                <i class="fa-solid fa-passport me-1"></i> Ingreso Guía Salida
              </button>
            </div>
          </div>

          <div class="card-body p-2">
            <div class="table-responsive">
              <table id="naciona" class="table table-striped table-hover table-sm w-100">
                <thead class="table-info">
                  <tr>
                    <th>Régimen</th>
                    <th>DAI 10</th>
                    <th>Nº Item</th>
                    <th>Marca</th>
                    <th>Modelo</th>
                    <th>Color</th>
                    <th>Nº de Chasis</th>
                    <th>Nº de Motor</th>
                    <th>Acción</th>
                  </tr>
                </thead>
                <tbody></tbody>
              </table>
            </div>
          </div>

        </div>
      </div>
    </main>
  </div>
</div>

<!-- Modal: Ingreso Guía de Transporte (padre) -->
<div class="modal fade" id="guia_transporte"
     data-bs-backdrop="static" data-bs-keyboard="false"
     tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header py-2">
        <h6 class="modal-title">Datos de la guía de salida</h6>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>

      <div class="modal-body">
        <form id="formGuia" autocomplete="off">
          <!-- ===== Encabezado ===== -->
          <div class="row g-2">
            <div class="col-lg-8">
              <label class="form-label">Compañía *</label>
              <input type="text" class="form-control" id="compania3" name="compania3" required>
            </div>
            <div class="col-lg-2">
              <label class="form-label">Nº Guía *</label>
              <input type="text" class="form-control" id="guia3" name="guia3" required>
            </div>
            <div class="col-lg-2">
              <label class="form-label">Placa *</label>
              <input type="text" class="form-control" id="placa3" name="placa3" required>
            </div>
            <div class="col-lg-3">
              <label class="form-label">Cédula Chofer *</label>
              <input type="text" class="form-control" id="cedula3" name="cedula3" required>
            </div>
            <div class="col-lg-5">
              <label class="form-label">Nombres Chofer *</label>
              <input type="text" class="form-control" id="nombre3" name="nombre3" required>
            </div>
            <div class="col-lg-3">
              <label class="form-label">Fecha salida *</label>
              <input type="date" class="form-control" id="fechasalida" name="fechasalida" required>
            </div>
            <div class="col-12 d-none">
              <label class="form-label">Observaciones de despacho</label>
              <textarea id="observacionesd" name="observacionesd" class="form-control" rows="3"></textarea>
            </div>
          </div>

          <hr class="my-3">

          <!-- ===== Bloque de chasis ===== -->
          <div id="guia_auto">
            <div class="d-flex align-items-center justify-content-between mb-2">
              <h6 class="mb-0">Agregar vehículos por chasis</h6>
              <div class="d-flex gap-2">
                <button type="button" class="btn btn-outline-secondary btn-sm" id="btnLimpiarTabla">
                  <i class="fa-solid fa-broom"></i> Limpiar lista
                </button>
              </div>
            </div>

            <!-- Entrada chasis (+ observación por defecto oculta) -->
            <div class="row g-2 align-items-end">
              <div class="col-12 col-md-7">
                <label class="form-label">Chasis *</label>
                <div class="input-group">
                  <input class="form-control" id="chasis"
                         placeholder="Escribe uno o varios chasis (separados por espacio, coma o Enter) y presiona Enter">
                  <button type="button" class="btn btn-primary" id="btnBuscarChasis" title="Buscar y agregar">
                    <i class="fa-solid fa-magnifying-glass"></i>
                  </button>
                </div>
                <div class="form-text">Se agregará automáticamente si existe y no está repetido.</div>
              </div>
              <div class="col-12 col-md-5 d-none">
                <label class="form-label">Observación por defecto</label>
                <input class="form-control" id="observa" value="S/N">
              </div>
              <!-- Alternativa: input oculto total -->
              <!-- <input type="hidden" id="observa" value="S/N"> -->
            </div>

            <!-- Tabla buffer -->
            <div class="table-responsive mt-3">
              <table id="carros" class="table table-hover table-sm align-middle">
                <thead>
                  <tr class="table-success">
                    <th style="width:20%">Chasis</th>
                    <th style="width:18%">Marca</th>
                    <th style="width:26%">Modelo</th>
                    <th style="width:14%">Color</th>
                    <th style="width:14%">Observación</th>
                    <th style="width:8%" class="text-end">Acciones</th>
                  </tr>
                </thead>
                <tbody><!-- filas via JS --></tbody>
              </table>
              <div class="small text-muted">Registros en memoria: <span id="lblTotalFilas">0</span></div>
            </div>
          </div>
          <!-- /Bloque chasis -->
        </form>
      </div>

      <div class="modal-footer py-2">
        <button type="button" class="btn btn-primary btn-sm" id="btnGuardarTodo">
          <i class="fa-solid fa-floppy-disk me-1"></i> Guardar todo
        </button>
        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>

<!-- Modal chico: Observación por fila -->
<div class="modal fade" id="modalObs" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-sm modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header py-2">
        <h6 class="modal-title"><i class="fa-regular fa-note-sticky me-1"></i> Observación</h6>
        <button class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <input type="hidden" id="obsIndex">
        <div class="mb-2">
          <label class="form-label">Para chasis:</label>
          <input class="form-control" id="obsChasis" disabled>
        </div>
        <div>
          <label class="form-label">Observación</label>
          <textarea class="form-control" id="obsTexto" rows="4" placeholder="S/N"></textarea>
        </div>
      </div>
      <div class="modal-footer py-2">
        <button type="button" class="btn btn-success btn-sm" id="btnGuardarObs">
          <i class="fa-solid fa-check"></i> Guardar
        </button>
        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>

<!-- Modal: Editar valores -->
<div class="modal fade" id="editar_valores" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-sm modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header py-2">
        <h6 class="modal-title">Actualizar numeración</h6>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body">
        <form enctype="multipart/form-data" id="formEditar" autocomplete="off">
          <input type="hidden" id="iddai" name="iddai">
          <input type="hidden" id="idsalida" name="idsalida">
          <div class="mb-2">
            <label class="form-label">Número de DAI 10 *</label>
            <input type="text" class="form-control" id="numero" name="numero" required>
          </div>
        </form>
      </div>
      <div class="modal-footer py-2">
        <button type="button" onclick="actualizar()" class="btn btn-success btn-sm">Actualizar</button>
        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>

<!-- Modal: Eliminar guía -->
<div class="modal fade" id="eliminar_guia" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-sm modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-body">
        <form enctype="multipart/form-data" id="formEliminar">
          <input type="hidden" id="id_guia" name="id_guia">
          <p class="mb-0">¿Seguro que desea eliminar?</p>
        </form>
      </div>
      <div class="modal-footer py-2">
        <button type="button" onclick="eliminar()" class="btn btn-danger btn-sm">Sí</button>
        <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">No</button>
      </div>
    </div>
  </div>
</div>

<!-- ===== JS ===== -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<!-- DataTables (DT + Buttons + Responsive) -->
<script src="https://cdn.datatables.net/v/bs5/jszip-3.10.1/dt-1.13.8/b-2.4.2/b-colvis-2.4.2/b-html5-2.4.2/b-print-2.4.2/r-2.5.0/datatables.min.js"></script>
<!-- Dependencias para PDF -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>

<script>
$(function() {
  /* ====== DataTable de Nacionalizados ====== */
  const dt = $('#naciona').DataTable({
    ajax: {
      url: 'api/nacionalizado_list.php', // debe devolver {data:[...]}
      type: 'GET',
      dataSrc: 'data'
    },
    columns: [
      { data: 'regimen' },
      { data: 'dai10' },
      { data: 'item' },
      { data: 'marca' },
      { data: 'modelo' },
      { data: 'color' },
      { data: 'chasis' },
      { data: 'motor' },
      { data: 'accion', orderable: false, className: 'text-center' }
    ],
    responsive: true,
    deferRender: true,
    pageLength: 25,
    language: { url: 'https://cdn.datatables.net/plug-ins/1.13.8/i18n/es-ES.json' }
  });

  /* ====== Bootstrap tooltips ====== */
  const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
  tooltipTriggerList.map(el => new bootstrap.Tooltip(el));
  // Re-inicializar tooltips tras cada draw (por los botones que vienen del backend)
  $('#naciona').on('draw.dt', function() {
    const tts = [].slice.call(document.querySelectorAll('#naciona [data-bs-toggle="tooltip"]'));
    tts.map(el => new bootstrap.Tooltip(el));
  });

  /* ====== Modales ====== */
  const modalGuia  = new bootstrap.Modal(document.getElementById('guia_transporte'));
  const modalEdit  = new bootstrap.Modal(document.getElementById('editar_valores'));
  const modalDel   = new bootstrap.Modal(document.getElementById('eliminar_guia'));

  $('#btnAbrirGuia').on('click', () => {
    document.getElementById('formGuia').reset();
    // deja el valor por defecto de observa en "S/N"
    const obsDef = document.getElementById('observa');
    if (obsDef) obsDef.value = 'S/N';
    modalGuia.show();
  });

  /* ====== Rellenar modal EDITAR desde botón generado por API ======
     El API arma botones tipo:
     <a id="btnnotifi{iddatadai}" data-ideq="{iddatadai}" data-ideq2="{numeros}" data-ideq3="{iddaisalida}" ...>
  */
  $(document).on('click', 'a[id^="btnnotifi"]', function() {
    const iddai     = $(this).data('ideq');   // iddatadai
    const numeros   = $(this).data('ideq2');  // ds.numeros (DAI 10)
    const idsalida  = $(this).data('ideq3');  // ds.iddaisalida
    $('#iddai').val(iddai);
    $('#idsalida').val(idsalida);
    $('#numero').val(numeros || '');
    modalEdit.show();
  });

  /* ====== Abrir modal ELIMINAR (si usas algún botón con data-id_guia) ====== */
  $(document).on('click', '.open-eliminar-guia', function() {
    const idGuia = $(this).data('id_guia');
    $('#id_guia').val(idGuia || '');
    modalDel.show();
  });

  /* ====== Stubs (ajusta con tus endpoints si aplica) ====== */
  window.actualizar = window.actualizar || function() {
    const idsalida = $('#idsalida').val();
    const numero   = $('#numero').val().trim();
    if (!idsalida || !numero) { alert('Completa los campos'); return; }
    alert('Implementar actualizar(): enviar a tu endpoint y luego dt.ajax.reload().');
    // dt.ajax.reload(null, false);
  };

  window.eliminar = window.eliminar || function() {
    const id_guia = $('#id_guia').val();
    if (!id_guia) { alert('Falta id_guia'); return; }
    alert('Implementar eliminar(): usar #id_guia en tu endpoint; luego dt.ajax.reload().');
    // dt.ajax.reload(null, false);
  };
});
</script>

<script>
(function () {
  // ===== Buffer en memoria =====
  let guiaItems = []; // { chasis, marca, modelo, color, observa }

  // ===== Utils =====
  const $ = (sel) => document.querySelector(sel);
  // Modal de observación con backdrop estático para evitar cerrar el padre
  const obsModal = new bootstrap.Modal('#modalObs', {
    backdrop: 'static',
    keyboard: false,
    focus: true
  });

  function renderTabla() {
    const tbody = $('#carros tbody');
    tbody.innerHTML = '';
    guiaItems.forEach((it, idx) => {
      const tr = document.createElement('tr');
      tr.innerHTML = `
        <td>${it.chasis}</td>
        <td>${it.marca || ''}</td>
        <td>${it.modelo || ''}</td>
        <td>${it.color || ''}</td>
        <td>
          <span class="d-inline-block text-truncate" style="max-width: 160px;" title="${it.observa || ''}">
            ${it.observa || ''}
          </span>
        </td>
        <td class="text-end">
          <button type="button" class="btn btn-sm btn-outline-secondary me-1" data-action="obs" data-index="${idx}" title="Editar observación">
            <i class="fa-regular fa-note-sticky"></i>
          </button>
          <button type="button" class="btn btn-sm btn-outline-danger" data-action="del" data-index="${idx}" title="Quitar fila">
            <i class="fa-solid fa-trash"></i>
          </button>
        </td>
      `;
      tbody.appendChild(tr);
    });
    document.getElementById('lblTotalFilas').textContent = guiaItems.length;
  }

  const existeChasis = (ch) => guiaItems.some(x => x.chasis === ch);

  // Tokenizar múltiples chasis (coma, espacio, tabs, Enter)
  function tokenizarChasis(input) {
    return (input || '')
      .split(/[,\s]+/g)
      .map(t => (t || '').trim())
      .filter(Boolean)
      .map(t => t.toUpperCase());
  }

  // Buscar y auto-agregar múltiples chasis
  async function buscarYAgregarMultiple() {
    const raw = document.getElementById('chasis').value;
    const tokens = Array.from(new Set(tokenizarChasis(raw)));
    if (!tokens.length) { alert('Ingrese uno o varios chasis'); return; }

    const obsDef = (document.getElementById('observa').value || 'S/N').trim();

    let agregados = 0;
    let repetidos = [];
    let noEncontrados = [];
    let errores = [];

    for (const chasis of tokens) {
      if (existeChasis(chasis)) { repetidos.push(chasis); continue; }
      try {
        const url = `api/vehiculo_por_chasis.php?chasis=${encodeURIComponent(chasis)}`;
        const resp = await fetch(url);
        const data = await resp.json();

        if (!resp.ok || !data?.success || !data?.vehiculo) {
          noEncontrados.push(chasis);
          continue;
        }

        guiaItems.push({
          chasis,
          marca:  data.vehiculo.marca  || '',
          modelo: data.vehiculo.modelo || '',
          color:  data.vehiculo.color  || '',
          observa: obsDef
        });
        agregados++;
      } catch (e) {
        errores.push(chasis);
      }
    }

    renderTabla();

    // limpiar input y preparar siguiente
    document.getElementById('chasis').value = '';
    document.getElementById('chasis').focus();

    // Resumen
    const partes = [];
    partes.push(`Agregados: ${agregados}`);
    if (repetidos.length)    partes.push(`Repetidos: ${repetidos.length} (${repetidos.slice(0,5).join(', ')}${repetidos.length>5?'…':''})`);
    if (noEncontrados.length)partes.push(`No encontrados: ${noEncontrados.length} (${noEncontrados.slice(0,5).join(', ')}${noEncontrados.length>5?'…':''})`);
    if (errores.length)      partes.push(`Errores: ${errores.length} (${errores.slice(0,5).join(', ')}${errores.length>5?'…':''})`);
    alert(partes.join('\n'));
  }

  // Enter en chasis -> buscar y auto-agregar múltiple
  document.getElementById('chasis').addEventListener('keydown', (e) => {
    if (e.key === 'Enter') {
      e.preventDefault();
      buscarYAgregarMultiple();
    }
  });
  // Click en lupa -> buscar y auto-agregar múltiple
  document.getElementById('btnBuscarChasis').addEventListener('click', buscarYAgregarMultiple);

  // Editar/Quitar (delegado) — evita que cierre el modal padre
  document.getElementById('carros').addEventListener('click', (ev) => {
    const btn = ev.target.closest('button[data-action]');
    if (!btn) return;

    ev.preventDefault();
    ev.stopPropagation();

    const idx = parseInt(btn.dataset.index, 10);
    if (Number.isNaN(idx)) return;

    if (btn.dataset.action === 'del') {
      if (confirm('¿Quitar este registro?')) {
        guiaItems.splice(idx, 1);
        renderTabla();
      }
      return;
    }

    if (btn.dataset.action === 'obs') {
      const fila = guiaItems[idx];
      document.getElementById('obsIndex').value = String(idx);
      document.getElementById('obsChasis').value = fila.chasis;
      document.getElementById('obsTexto').value = fila.observa || '';
      obsModal.show();
    }
  });

  // Guardar observación
  document.getElementById('btnGuardarObs').addEventListener('click', () => {
    const idx = parseInt(document.getElementById('obsIndex').value, 10);
    if (!Number.isInteger(idx) || idx < 0 || idx >= guiaItems.length) return;
    guiaItems[idx].observa = (document.getElementById('obsTexto').value || '').trim();
    obsModal.hide();
    renderTabla();
  });

  // Limpiar tabla
  document.getElementById('btnLimpiarTabla').addEventListener('click', () => {
    if (!guiaItems.length) return;
    if (confirm('¿Vaciar la lista de vehículos?')) {
      guiaItems = [];
      renderTabla();
    }
  });

  // Guardar todo
  document.getElementById('btnGuardarTodo').addEventListener('click', async () => {
    const encabezado = {
      compania3:      document.getElementById('compania3').value.trim(),
      guia3:          document.getElementById('guia3').value.trim(),
      placa3:         document.getElementById('placa3').value.trim(),
      cedula3:        document.getElementById('cedula3').value.trim(),
      nombre3:        document.getElementById('nombre3').value.trim(),
      fechasalida:    document.getElementById('fechasalida').value,
      observacionesd: document.getElementById('observacionesd').value.trim()
    };

    if (!encabezado.compania3 || !encabezado.guia3 || !encabezado.placa3 ||
        !encabezado.cedula3 || !encabezado.nombre3 || !encabezado.fechasalida) {
      alert('Complete los campos requeridos del encabezado');
      return;
    }
    if (!guiaItems.length) {
      alert('Agregue al menos un chasis a la guía');
      return;
    }

    const btn = document.getElementById('btnGuardarTodo');
    btn.disabled = true;
    const old = btn.innerHTML;
    btn.innerHTML = '<i class="fa-solid fa-spinner fa-spin me-1"></i> Guardando...';

    try {
      const resp = await fetch('api/guia_guardar_batch.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json;charset=utf-8' },
        body: JSON.stringify({ encabezado, items: guiaItems })
      });
      const data = await resp.json();
      if (!resp.ok || !data?.success) throw new Error(data?.message || 'No se pudo guardar');

      alert(`Guía #${data.idguia} guardada con ${guiaItems.length} vehículo(s).`);
      document.getElementById('formGuia').reset();
      guiaItems = [];
      renderTabla();

      // Cerrar modal y refrescar DataTable si está presente
      const m = bootstrap.Modal.getInstance(document.getElementById('guia_transporte'));
      m && m.hide();
      if (window.$ && $('#naciona').length) {
        $('#naciona').DataTable().ajax.reload(null, false);
      }
    } catch (e) {
      alert(e.message || 'Error al guardar');
    } finally {
      btn.disabled = false;
      btn.innerHTML = old;
    }
  });

  // Arranque
  renderTabla();
})();
</script>

</body>
</html>
