<?php
// importar_s/import.php — Importa Excel del Régimen Simple con control de duplicados por chasis (dai='Simple')
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');

session_start();
require_once __DIR__ . '/../conex.php';

$vendor = realpath(__DIR__ . '/../../../vendor/autoload.php') ?: realpath(__DIR__ . '/../../vendor/autoload.php');
if (!$vendor) {
  echo json_encode(['success'=>false,'message'=>'No se encontró vendor/autoload.php']); exit;
}
require_once $vendor;

use PhpOffice\PhpSpreadsheet\IOFactory;

date_default_timezone_set('America/Guayaquil');
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

/* ====== INPUT ====== */
$id_usuario   = (int)($_SESSION['idusuario'] ?? 0);
$importador   = (int)($_POST['importador'] ?? 0); // id_empresa
$bodega       = (int)($_POST['bodega'] ?? 0);     // id_bodega
$nombre_arch  = $_FILES['name']['name'] ?? '';
$regimen      = 'Simple';                         // se guarda en tb_datadai.dai
$categoria    = 1;
$condicion    = 1;
$temp         = 1;
$estado       = 1;
$cantidad     = 1;
$id_ubicacion = 1;
$actividad    = 'REGISTRO DE UNIDADES REGIMEN SIMPLE';

$fecha_actual = date('Y-m-d');
$hora_actual  = date('H:i:s');
$ip           = $_SERVER['REMOTE_ADDR'] ?? '';

if ($id_usuario <= 0 || $importador <= 0 || $bodega <= 0) {
  echo json_encode(['success'=>false,'message'=>'Faltan datos requeridos (usuario/importador/bodega).']); exit;
}

if (!isset($_FILES['name']) || $_FILES['name']['error'] !== UPLOAD_ERR_OK) {
  echo json_encode(['success'=>false,'message'=>'Archivo no enviado o inválido.']); exit;
}

$ext = strtolower(pathinfo($nombre_arch, PATHINFO_EXTENSION));
if ($ext !== 'xlsx') {
  echo json_encode(['success'=>false,'message'=>'Solo se permiten archivos .xlsx']); exit;
}

$archivoTmp = $_FILES['name']['tmp_name'];
$resumen = ['insertados'=>0, 'duplicados'=>0, 'errores'=>0];

/* ====== TRANSACCIÓN ====== */
$conn->begin_transaction();
try {
  // 1) Crear solicitud previa
  $stmt1 = $conn->prepare("INSERT INTO tb_solicitudprevia
      (anio, numero, codigo, numerosp, fecha, id_empresa, id_categoria, condicion)
      VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
  // 5 strings + 3 ints
  $simple = 'Simple';
  $stmt1->bind_param(
    "sssssiii",
    $simple,       // anio
    $simple,       // numero
    $simple,       // codigo
    $simple,       // numerosp
    $fecha_actual, // fecha (DATE)
    $importador,   // id_empresa
    $categoria,    // id_categoria
    $condicion     // condicion
  );
  $stmt1->execute();
  $id_solicitudprevia = $conn->insert_id;

  // 2) Crear DAI de entrada temporal (enlazado a solicitud)
  $stmt2 = $conn->prepare("INSERT INTO tb_daientrada
      (numerodai, fecha, fecha_v, id_solicitudprevia, temporal, id_bodega, condicion)
      VALUES (?, ?, ?, ?, ?, ?, ?)");
  // 3 str + 4 int
  $stmt2->bind_param(
    "sssiiii",
    $simple,        // numerodai
    $fecha_actual,  // fecha
    $fecha_actual,  // fecha_v
    $id_solicitudprevia,
    $temp,
    $bodega,
    $condicion
  );
  $stmt2->execute();
  $id_daientrada = $conn->insert_id;

  // 3) Auditoría
  $stmt3 = $conn->prepare("INSERT INTO tb_auditoria (fecha, hora, ip, detalle, id_daientrada, id_usuario)
                           VALUES (?, ?, ?, ?, ?, ?)");
  $stmt3->bind_param("ssssii", $fecha_actual, $hora_actual, $ip, $actividad, $id_daientrada, $id_usuario);
  $stmt3->execute();

  // Guardo en sesión (si usas después)
  $_SESSION['id_solicitudprevia'] = $id_solicitudprevia;
  $_SESSION['id_daientrada']      = $id_daientrada;
  $_SESSION['id_bodega']          = $bodega;

  // 4) Leer Excel
  $xl       = IOFactory::load($archivoTmp);
  $ws       = $xl->getSheet(0);
  $rows     = $ws->toArray(null, true, true, true);
  if (!$rows || count($rows) < 2) {
    throw new RuntimeException('El archivo no contiene registros.');
  }

  // 5) Preparados
  // Duplicado por chasis + dai='Simple' + condicion=1
  $stmt_check = $conn->prepare("SELECT iddatadai FROM tb_datadai WHERE chasis = ? AND dai = 'Simple' AND condicion = 1 LIMIT 1");

  // Insert de unidad (incluye naviera)
  // Asegúrate de tener la columna 'naviera' en tb_datadai (VARCHAR). Si no, créala:
  // ALTER TABLE tb_datadai ADD COLUMN naviera VARCHAR(120) NULL AFTER id_bodega;
  $stmt_insert = $conn->prepare("INSERT INTO tb_datadai (
      origen, origen_localidad, pedido, marca, modelo, color, chasis, motor, dai,
      id_daientrada, id_solicitudprevia, embarque, id_estado, cantidad, condicion,
      id_ubicacion, id_bodega, naviera, created_at
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())");

  // 6) Recorrer filas (asumiendo encabezado en fila 1):
  // Layout esperado:
  // A=Origen, B=Pedido, C=Embarque, D=Marca, E=Modelo, F=Color, G=Chasis, H=Motor, I=Naviera
  $vistos = [];
  foreach ($rows as $i => $fila) {
    if ($i === 1) continue; // skip header

    $origen           = trim((string)($fila['A'] ?? ''));
    $pedido           = trim((string)($fila['B'] ?? ''));
    $embarque         = trim((string)($fila['C'] ?? ''));
    $marca            = trim((string)($fila['D'] ?? ''));
    $modelo           = trim((string)($fila['E'] ?? ''));
    $color            = trim((string)($fila['F'] ?? ''));
    $chasis           = strtoupper(trim((string)($fila['G'] ?? '')));
    $motor            = strtoupper(trim((string)($fila['H'] ?? '')));
    $naviera          = trim((string)($fila['I'] ?? ''));
    $origen_localidad = $origen;

    if ($chasis === '' || $marca === '') {
      $resumen['errores']++; // datos mínimos inválidos
      continue;
    }

    // Evitar duplicados dentro del mismo archivo
    if (isset($vistos[$chasis])) {
      $resumen['duplicados']++;
      continue;
    }

    // Chequeo duplicado en BD
    $stmt_check->bind_param("s", $chasis);
    $stmt_check->execute();
    $stmt_check->store_result();
    if ($stmt_check->num_rows > 0) {
      $vistos[$chasis] = true;
      $resumen['duplicados']++;
      continue;
    }

    // Insertar
    $stmt_insert->bind_param(
      "sssssssssiisiiiiis",
      $origen,
      $origen_localidad,
      $pedido,
      $marca,
      $modelo,
      $color,
      $chasis,
      $motor,
      $regimen,             // dai = 'Simple'
      $id_daientrada,
      $id_solicitudprevia,
      $embarque,
      $estado,
      $cantidad,
      $condicion,
      $id_ubicacion,
      $bodega,
      $naviera
    );

    try {
      $stmt_insert->execute();
      $resumen['insertados']++;
      $vistos[$chasis] = true;
    } catch (Throwable $e) {
      $resumen['errores']++;
    }
  }

  // 7) Bitácora
  $stmt_log = $conn->prepare("INSERT INTO tb_bitacora_importaciones 
      (nombre_archivo, id_usuario, id_solicitudprevia, id_daientrada, fecha)
      VALUES (?, ?, ?, ?, NOW())");
  $stmt_log->bind_param("siii", $nombre_arch, $id_usuario, $id_solicitudprevia, $id_daientrada);
  $stmt_log->execute();

  // 8) Commit
  $conn->commit();

  echo json_encode([
    'success'    => true,
    'insertados' => $resumen['insertados'],
    'duplicados' => $resumen['duplicados']
    /*'errores'    => $resumen['errores']*/
  ]);
} catch (Throwable $e) {
  $conn->rollback();
  echo json_encode(['success'=>false, 'message'=>'Error en transacción: '.$e->getMessage()]);
}
