<?php
$motivo = $_GET['motivo'] ?? '';
$mensaje = 'Tu sesión ha finalizado.';

switch ($motivo) {
    case 'expirado':
        $mensaje = '⏰ Tu sesión ha expirado por inactividad.';
        break;
    case 'secuestro_detectado':
        $mensaje = '🛡️ Por seguridad, tu sesión fue cerrada (posible cambio de red o navegador).';
        break;
    case 'no_autorizado':
        $mensaje = '⛔ Acceso no autorizado. Por favor, inicia sesión.';
        break;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Sesión finalizada</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: #f7f7f7;
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100vh;
        }
        .card {
            padding: 2rem;
            text-align: center;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            border-radius: 12px;
        }
        .emoji {
            font-size: 3rem;
        }
    </style>
</head>
<body>
    <div class="card">
        <div class="emoji">😕</div>
        <h3 class="mt-3">Aviso de sesión</h3>
        <p class="text-muted"><?= htmlspecialchars($mensaje) ?></p>
        <a href="index.php" class="btn btn-primary mt-3">
            <i class="fas fa-sign-in-alt"></i> Volver al login
        </a>
    </div>
</body>
</html>
