<?php
// index.php — Nacionalización Directa (con modal de ítems y modal de detalle de ítem)
session_start();
if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') {
  header("Location: ../../views/index.php"); exit();
}
$usuario = $_SESSION['usuario'] ?? '';
$permiso = $_SESSION['permiso'] ?? '';
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <title>SGO · Nacionalización Directa</title>

  <!-- Bootstrap 5 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"/>
  <!-- Font Awesome -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet"/>
  <!-- DataTables (DT + Buttons + Responsive) -->
  <link rel="stylesheet"
        href="https://cdn.datatables.net/v/bs5/jszip-3.10.1/dt-1.13.8/b-2.4.2/b-colvis-2.4.2/b-html5-2.4.2/b-print-2.4.2/r-2.5.0/datatables.min.css"/>

  <style>
    :root { --fz: 1.02rem; }
    body { font-size: var(--fz); }
    .table td, .table th { vertical-align: middle; }
    .btn-sm { padding: .25rem .5rem; }
    .modal-header { background:#f6f7fb; }
    table.dataTable tbody tr > * { padding-top:.35rem; padding-bottom:.35rem; }
    .dataTables_wrapper .dt-buttons { margin-bottom:.5rem; }
    .row-disabled { opacity: .55; }
    tr.clickable-row { cursor: pointer; }
    .badge-status { font-size: .80rem; }
    .input-inline { max-width: 260px; }
    .no-row-open { pointer-events: auto; }
  </style>
</head>
<body>
<div class="container-fluid">
  <div class="row">
    <!-- Sidebar -->
    <?php include __DIR__ . '/partials/menu.php'; ?>

    <!-- Contenido principal -->
    <main class="col-md-9 ms-sm-auto col-lg-10 px-0">
      <!-- Topbar -->
      <?php include __DIR__ . '/partials/topbar.php'; ?>

      <div class="container-fluid py-2">
        <div class="card shadow-sm">
          <div class="card-header py-2 d-flex align-items-center justify-content-between">
            <div>
              <i class="fa-solid fa-flag-checkered me-2"></i> Nacionalización Directa
            </div>
            <div class="d-flex gap-2 align-items-center">
              <input type="text" id="qDai" class="form-control form-control-sm input-inline" placeholder="Filtrar por DAI...">
              <input type="text" id="qRuc" class="form-control form-control-sm input-inline" placeholder="Filtrar por RUC...">
              <button id="btnClearFilters" class="btn btn-outline-secondary btn-sm"><i class="fa-solid fa-eraser"></i></button>
            </div>
          </div>
          <div class="card-body p-2">
            <div class="table-responsive">
              <table id="directa" class="table table-striped table-hover table-sm w-100">
                <thead class="table-info">
                  <tr>
                    <th>DAI 70</th>
                    <th>RUC</th>
                    <th>IMPORTADOR/CONSIGNATARIO</th>
                    <th>CANTIDAD ITEMS</th>
                    <th>ACCIONES</th>
                  </tr>
                </thead>
                <tbody></tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </main>
  </div>
</div>

<!-- Modal: Ítems por DAI -->
<div class="modal fade" id="modalItems" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header py-2">
        <h6 class="modal-title">
          <i class="fa-solid fa-list-check me-2"></i>
          Ítems del DAI <span id="mi_dai" class="text-primary"></span>
        </h6>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>
      <div class="modal-body p-2">
        <button id="btnNacionalizacion" class="btn btn-success btn-sm">
          <i class="fa-solid fa-clipboard-check me-1"></i> Nacionalización
        </button>

        <div class="table-responsive">
          <table id="items" class="table table-striped table-hover table-sm w-100">
            <thead class="table-info">
              <tr>
                <th>ITEM</th>
                <th>CHASIS</th>
                <th>MARCA</th>
                <th>MODELO</th>
                <th>COLOR</th>
                <th>MOTOR</th>               
                <th>ACCIONES</th>
              </tr>
            </thead>
            <tbody></tbody>
          </table>
        </div>
        <div id="mi_error" class="alert alert-danger d-none my-2"></div>
      </div>
      <div class="modal-footer py-2">
        <button type="button" class="btn btn-light btn-sm" data-bs-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>
<!-- Modal: Nacionalización -->
<div class="modal fade" id="modalNacionalizacion" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-md modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header py-2">
        <h6 class="modal-title">
          <i class="fa-solid fa-clipboard-check me-2"></i> Nacionalización
        </h6>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>

      <div class="modal-body">
        <div class="mb-3">
          <label for="aprob_dai10" class="form-label">Número de DAI 10 *</label>
          <input type="text" class="form-control" id="aprob_dai10" placeholder="Ej. 123-2025-0001234" />
          <div class="invalid-feedback">Formato inválido. Ejemplo: 123-2025-0001234</div>
        </div>

        <div class="mb-3">
          <label for="aprob_regimen" class="form-label">Régimen *</label>
          <select class="form-select" id="aprob_regimen">
            <option value="">Cargando...</option>
          </select>
          <div class="invalid-feedback">Selecciona un régimen.</div>
        </div>
      </div>

      <div class="modal-footer py-2">
        <button type="button" class="btn btn-light btn-sm" data-bs-dismiss="modal">Cancelar</button>
        <button type="button" id="btnNacContinuar" class="btn btn-success btn-sm">
          <i class="fa-solid fa-check me-1"></i> Continuar
        </button>
      </div>
    </div>
  </div>
</div>

<!-- ===== JS ===== -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<!-- DataTables (DT + Buttons + Responsive) -->
<script src="https://cdn.datatables.net/v/bs5/jszip-3.10.1/dt-1.13.8/b-2.4.2/b-colvis-2.4.2/b-html5-2.4.2/b-print-2.4.2/r-2.5.0/datatables.min.js"></script>
<!-- Dependencias para PDF -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>

<script>
(function(){
  function estadoMap(st){
    switch (parseInt(st,10)) {
      case 1: return {txt:'Pendiente', cls:'text-bg-secondary'};
      case 2: return {txt:'En proceso', cls:'text-bg-warning'};
      case 3: return {txt:'Listo', cls:'text-bg-success'};
      default: return {txt:`Estado ${st}`, cls:'text-bg-info'};
    }
  }

  // ===== DataTable principal (DAI agrupados) =====
  const dtDirecta = $('#directa').DataTable({
    ajax: {
      url: 'api/directa_list.php',
      type: 'GET',
      dataSrc: function (json) {
        if (!json || json.success === false) {
          console.error('Error de API:', json && json.message ? json.message : 'Respuesta inválida');
          return [];
        }
        return json.data || [];
      },
      error: function (xhr) { console.error('Error AJAX:', xhr.responseText || xhr.statusText); }
    },
    columns: [
      { data: 'dai70', defaultContent: '-' },
      { data: 'ruc', defaultContent: '-' },
      { data: 'importador', defaultContent: '-' },
      { data: 'items', className: 'text-end', render: d => parseInt(d||0,10).toLocaleString() },
      {
        data: null,
        orderable: false, searchable: false, className:'text-center',
        render: function(row){
          return `
            <div class="btn-group btn-group-sm no-row-open" role="group">
              <button class="btn btn-primary btn-items" title="Ver ítems" data-dai="${row.dai70 || ''}">
                <i class="fa-solid fa-eye"></i>
              </button>              
            </div>`;
        }
      }
    ],
    createdRow: function (row, data) {
      $(row).addClass('clickable-row').attr('data-dai', data.dai70 || '');
      // if (String(data.estado) === '8') { $(row).addClass('row-disabled'); }
    },
    order: [[0, 'desc']],
    responsive: true,
    deferRender: true,
    pageLength: 25,
    lengthMenu: [[10,25,50,100,-1],[10,25,50,100,'Todos']],
    
    language: { url: 'https://cdn.datatables.net/plug-ins/1.13.8/i18n/es-ES.json' }
  });

  // Filtros rápidos
  $('#qDai').on('keyup change', function(){ dtDirecta.column(0).search(this.value).draw(); });
  $('#qRuc').on('keyup change', function(){ dtDirecta.column(1).search(this.value).draw(); });
  $('#btnClearFilters').on('click', function(){
    $('#qDai,#qRuc').val('');
    dtDirecta.search('').columns().search('').draw();
  });

  // Botón PDF
  $('#directa').on('click', '.btn-pdf', function(e){
    e.stopPropagation();
    const dai = this.dataset.dai || '';
    if (!dai) return;
    window.open('reportes/directa_pdf.php?dai=' + encodeURIComponent(dai), '_blank');
  });

  // Abrir modal de Ítems por botón
  $('#directa').on('click', '.btn-items', function(e){
    e.stopPropagation();
    const dai = this.dataset.dai || '';
    if (!dai) return;
    openItemsModal(dai);
  });

  // Abrir modal de Ítems por click en fila (excepto botones)
  $('#directa tbody').on('click', 'tr', function(e){
    if ($(e.target).closest('.no-row-open, .btn, a, input, select, label').length) return;
    const dai = $(this).data('dai') || '';
    if (dai) openItemsModal(dai);
  });

  // ===== Modal de Ítems =====
  const modalItems = new bootstrap.Modal(document.getElementById('modalItems'));
  let dtItems = null;

  function openItemsModal(dai){
    $('#mi_dai').text('# ' + dai);
    $('#mi_error').addClass('d-none').text('');
    if (dtItems) {
      // Cambia URL y recarga
      dtItems.ajax.url('api/directa_item_info.php?dai=' + encodeURIComponent(dai)).load();
      modalItems.show();
      return;
    }
    // Inicializa una sola vez
    dtItems = $('#items').DataTable({
      ajax: {
        url: 'api/directa_item_info.php?dai=' + encodeURIComponent(dai),
        type: 'GET',
        dataSrc: function (json) {
          if (!json || json.success === false) {
            $('#mi_error').removeClass('d-none').text(json && json.message ? json.message : 'Error al cargar ítems');
            return [];
          }
          return json.data || [];
        }
      },
      columns: [
        { data:'item', className:'text-center', defaultContent:'-' },
        { data:'chasis', defaultContent:'-' },
        { data:'marca', defaultContent:'-' },
        { data:'modelo', defaultContent:'-' },
        { data:'color', defaultContent:'-' },
        { data:'motor', defaultContent:'-' },
        
        
        {
          
    data:null,
    orderable:false,
    searchable:false,
    className:'text-center',
    render:function(row){
      const id = row.id || ''; // iddatadai que devuelve tu API
      const pdfUrl = `pdf/index.php?id=${encodeURIComponent(id)}`;
      return `
        <div class="btn-group btn-group-sm no-row-open" role="group">
          
          <a class="btn btn-danger" href="${pdfUrl}" target="_blank" title="Tarja PDF">
            <i class="fa-solid fa-file-pdf"></i>
          </a>
        </div>`;
    }
  }
],
      createdRow:function(row, data){ $(row).attr('data-id', data.id || ''); },
      order:[[0,'asc']],
      responsive:true,
      deferRender:true,
      pageLength:25,
      lengthMenu:[[10,25,50,100,-1],[10,25,50,100,'Todos']],
      
      language:{ url:'https://cdn.datatables.net/plug-ins/1.13.8/i18n/es-ES.json' }
    });

    modalItems.show();
  }

  // Filtro rápido en Ítems
  $('#mi_qChasis').on('keyup change', function(){
    if (dtItems) dtItems.column(1).search(this.value).draw();
  });
  $('#mi_btnClear').on('click', function(){
    $('#mi_qChasis').val('');
    if (dtItems) dtItems.search('').columns().search('').draw();
  });


  // ===== Modal de Detalle de Ítem =====
  const modalItem = new bootstrap.Modal(document.getElementById('modalItem'));
  const $mdErr = $('#md_error');
  const mdEl = id => document.getElementById(id);
  function toggleMDLoad(on){
    mdEl('md_loading').style.display = on ? 'block':'none';
    mdEl('md_content').style.display = on ? 'none':'block';
    $mdErr.addClass('d-none').text('');
  }

  async function openItemModal(id){
    // Reset UI
    mdEl('md_item').textContent = '';
    ['md_chasis','md_motor','md_marca','md_modelo','md_color','md_dai','md_fecha_ingreso','md_empresa','md_ruc','md_bodega','md_ubicacion']
      .forEach(k => mdEl(k).textContent = '-');
    const badge = mdEl('md_estado_badge');
    badge.textContent = '-'; badge.className = 'badge text-bg-secondary';
    const qr = mdEl('md_qr_link'); qr.style.display='none'; qr.href='#';
    toggleMDLoad(true);
    modalItem.show();

    try {
      const res = await fetch('api/directa_item_info.php?id=' + encodeURIComponent(id));
      const json = await res.json();
      if (!json || json.success === false) throw new Error(json && json.message ? json.message : 'Error de API');

      const d = json.data || {};
      mdEl('md_item').textContent = d.item ?? '';
      mdEl('md_chasis').textContent = d.chasis ?? '-';
      mdEl('md_motor').textContent = d.motor ?? '-';
      mdEl('md_marca').textContent = d.marca ?? '-';
      mdEl('md_modelo').textContent = d.modelo ?? '-';
      mdEl('md_color').textContent = d.color ?? '-';
      mdEl('md_dai').textContent = d.dai ?? '-';
      mdEl('md_fecha_ingreso').textContent = d.fecha_ingreso ?? '-';
      mdEl('md_empresa').textContent = d.empresa ?? '-';
      mdEl('md_ruc').textContent = d.ruc ?? '-';
      mdEl('md_bodega').textContent = d.bodega ?? '-';
      mdEl('md_ubicacion').textContent = d.ubicacion ?? '-';

      const m = estadoMap(d.estado);
      badge.textContent = d.estado_txt || m.txt;
      badge.className = `badge ${d.estado_badge || m.cls}`;

      if (d.qr_url) { qr.href = d.qr_url; qr.style.display = 'inline-flex'; }

      toggleMDLoad(false);
    } catch(err){
      $mdErr.removeClass('d-none').text(err.message || 'No se pudo cargar el detalle.');
      toggleMDLoad(false);
    }
  }

  // Copiar chasis desde modal detalle
  document.getElementById('md_copy_chasis').addEventListener('click', async () => {
    const t = (document.getElementById('md_chasis').textContent || '').trim();
    if (!t || t === '-') return;
    try { await navigator.clipboard.writeText(t); } catch {}
  });

  // Tooltips (si añades más botones)
  const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
  tooltipTriggerList.forEach(el => new bootstrap.Tooltip(el));
})();
</script>
<script>
  // ===== Modal Nacionalización =====
  const modalNac = new bootstrap.Modal(document.getElementById('modalNacionalizacion'));
  const $dai10 = $('#aprob_dai10');
  const $regimen = $('#aprob_regimen');

  $('#btnNacionalizacion').on('click', async () => {
    // Limpia y muestra
    $dai10.val('').removeClass('is-invalid');
    $regimen.removeClass('is-invalid');
    await loadRegimenOptions(); // carga opciones (API o fallback)
    modalNac.show();
  });

  // Carga de opciones de régimen (intenta API, sino fallback)
  async function loadRegimenOptions(){
    if ($regimen.data('loaded') === 1) return; // evita recargar
    $regimen.html('<option value="">Cargando...</option>');
    try {
      const resp = await fetch('api/regimen_list.php'); // opcional si existe
      const json = await resp.json();
      const arr = (json && json.data) ? json.data : [];
      if (arr.length) {
        const opts = ['<option value="">Seleccione...</option>']
          .concat(arr.map(r => `<option value="${r.id}">${r.descripcion}</option>`));
        $regimen.html(opts.join(''));
        $regimen.data('loaded', 1);
        return;
      }
      throw new Error('Sin datos');
    } catch (e) {
      // Fallback rápido
      $regimen.html(`
        <option value="">Seleccione...</option>
          <option value="10">DAI 10</option>
          <option value="70">DAI 70</option>
          <option value="SIMPLE">SIMPLE</option>
      `);
      $regimen.data('loaded', 1);
    }
  }

  // Validación básica de formato DAI10: NNN-YYYY-NNNNNNN (ajusta si tu patrón difiere)
  function validaDai10(v){
    const s = String(v || '').trim();
    // 3 dígitos - 4 dígitos - 7 dígitos (modifica si necesitas otro largo)
    return /^[0-9]{3}-[0-9]{4}-[0-9]{7}$/.test(s);
  }

  $('#btnNacContinuar').on('click', () => {
    const vDai10 = $dai10.val().trim();
    const vReg = $regimen.val();

    // Validación UI
    let ok = true;
    if (!validaDai10(vDai10)) { $dai10.addClass('is-invalid'); ok = false; } else { $dai10.removeClass('is-invalid'); }
    if (!vReg) { $regimen.addClass('is-invalid'); ok = false; } else { $regimen.removeClass('is-invalid'); }

    if (!ok) return;

    // Aquí decides qué hacer al continuar:
    // - llamar a un endpoint para guardar/crear nacionalización
    // - o abrir el modal de ítems usando el número ingresado (si corresponde)
    // Ejemplo: solo cerrar y notificar (placeholder):
    modalNac.hide();

    // Si quieres abrir el modal de ítems reutilizando tu función:
    // openItemsModal(vDai10); // <-- solo si tu API acepta buscar por ese número
    // De lo contrario, aquí harías tu POST a api/nacionalizacion_aprobar.php con { dai10: vDai10, regimen: vReg }
  });

</script>
</body>
</html>
