<?php
require '../conex.php'; // Ajusta la ruta según tu estructura

header('Content-Type: application/json');

$input = json_decode(file_get_contents('php://input'), true);
$cedula = $input['cedula'] ?? '';

if (!$cedula) {
  echo json_encode(['success' => false, 'message' => 'Documento no recibido']);
  exit;
}

// Consulta en la tabla tb_asignar
$sql = "SELECT conductor AS nombre, placa 
        FROM tb_asignar 
        WHERE numero_doc = ? 
        AND condicion = 1 
        LIMIT 1";

$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $cedula);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
  echo json_encode([
    'success' => true,
    'nombre' => $row['nombre']
    //'placa' => $row['placa']
  ]);
} else {
  echo json_encode(['success' => false, 'message' => 'No encontrado']);
}
