<?php
declare(strict_types=1);
date_default_timezone_set('America/Guayaquil');

/* Cabeceras JSON + CORS */
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Access-Control-Allow-Methods: GET, OPTIONS');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

/* Conexión */
require __DIR__ . '/../conex.php'; 
if (!$conn instanceof mysqli) {
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>'Error de conexión a BD']); exit;
}
mysqli_set_charset($conn, "utf8mb4");

/* Consulta solo zonas activas */
try {
    $sql = "SELECT idzona AS value, detallezona AS nombre
            FROM tb_zona
            WHERE condicion = 1
            ORDER BY nombre ASC";
    $res = $conn->query($sql);

    $zonas = [];
    while ($row = $res->fetch_assoc()) {
        $zonas[] = $row;
    }

    echo json_encode(['success'=>true,'data'=>$zonas], JSON_UNESCAPED_UNICODE);
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode([
        'success'=>false,
        'message'=>'Error al consultar zonas',
        'detail'=>$e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
