<?php
declare(strict_types=1);
date_default_timezone_set('America/Guayaquil');

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

ini_set('display_errors', '0');
error_reporting(E_ALL);
set_error_handler(function($s,$m,$f,$l){
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>'PHP error','detail'=>"$m in $f:$l"], JSON_UNESCAPED_UNICODE); exit;
});
set_exception_handler(function($e){
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>'Exception','detail'=>$e->getMessage()], JSON_UNESCAPED_UNICODE); exit;
});

require '../conex.php';
if (function_exists('mysqli_report')) { mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT); }

// === Parámetros ===
$body = json_decode(file_get_contents('php://input'), true) ?: [];
$id_param     = $body['id'] ?? $body['id_registro'] ?? $_POST['id'] ?? $_POST['id_registro'] ?? $_GET['id'] ?? $_GET['id_registro'] ?? null;
$cedula_param = $body['cedula'] ?? $_POST['cedula'] ?? $_GET['cedula'] ?? null;

// === Detectar nombre de clave primaria de tb_registro ===
$pkCol = null;
$stmtPK = $conn->prepare("
  SELECT COLUMN_NAME
  FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE
  WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'tb_registro' AND CONSTRAINT_NAME = 'PRIMARY'
  LIMIT 1
");
$stmtPK->execute();
$resPK = $stmtPK->get_result();
if ($r = $resPK->fetch_assoc()) {
  $pkCol = $r['COLUMN_NAME'];
}
if (!$pkCol || !preg_match('/^[a-zA-Z0-9_]+$/', $pkCol)) {
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>'No se pudo detectar la clave primaria de tb_registro'], JSON_UNESCAPED_UNICODE);
  exit;
}

// === Resolver criterio de búsqueda ===
$where = '';
$bindTypes = '';
$bindVals = [];

if ($id_param !== null && $id_param !== '') {
  // Intentar entero
  if (is_numeric($id_param)) { $id_param = (int)$id_param; }
  $where = "WHERE `$pkCol` = ?";
  $bindTypes = is_int($id_param) ? 'i' : 's';
  $bindVals[] = $id_param;
} elseif ($cedula_param !== null && $cedula_param !== '') {
  $where = "WHERE `cedula` = ?";
  $bindTypes = 's';
  $bindVals[] = $cedula_param;
} else {
  http_response_code(400);
  echo json_encode([
    'success'=>false,
    'message'=>'Falta parámetro: envía id/id_registro (clave primaria) o cedula'
  ], JSON_UNESCAPED_UNICODE);
  exit;
}

// === Consulta ===
// Ajusta estos nombres si en tu tabla se llaman distinto.
$sql = "SELECT cedula, nombres, cargo, movil, condicion
        FROM tb_registro
        $where
        LIMIT 1";

$stmt = $conn->prepare($sql);
$stmt->bind_param($bindTypes, ...$bindVals);
$stmt->execute();
$res = $stmt->get_result();

if ($row = $res->fetch_assoc()) {
  // Cast opcional
  if (isset($row['condicion']) && is_numeric($row['condicion'])) $row['condicion'] = (int)$row['condicion'];
  echo json_encode(['success'=>true,'data'=>$row], JSON_UNESCAPED_UNICODE);
} else {
  http_response_code(404);
  echo json_encode(['success'=>false,'message'=>'No se encontró el registro', 'code'=>'not_found'], JSON_UNESCAPED_UNICODE);
}
