<?php
declare(strict_types=1);
date_default_timezone_set('America/Guayaquil');

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type');
header('Access-Control-Allow-Methods: POST, OPTIONS');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

ini_set('display_errors', '0');
error_reporting(E_ALL);

const DEV = true; // ← deja true para ver el motivo del 401

set_error_handler(function($s,$m,$f,$l){
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>'PHP error','detail'=> (DEV ? "$m in $f:$l" : '') ]);
  exit;
});
set_exception_handler(function($e){
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>'Exception','detail'=> (DEV ? $e->getMessage() : '') ]);
  exit;
});

require_once __DIR__ . '/../conex.php'; // Debe definir $conn (mysqli)

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  echo json_encode(['success'=>false,'message'=>'Método no permitido']); exit;
}

$in = json_decode(file_get_contents('php://input'), true);
if (!is_array($in) || empty($in)) $in = $_POST;

$usuario = trim($in['usuario'] ?? '');
$pass    = (string)($in['pass'] ?? '');
if ($usuario === '' || $pass === '') {
  http_response_code(400);
  echo json_encode(['success'=>false,'message'=>'Usuario y contraseña requeridos']); exit;
}

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

// ⚠️ Usa tu tabla/campos reales (aquí los más probables en tu sistema)
$stmt = $conn->prepare("
  SELECT 
    idusuario AS id, usuario, clave,
    permiso,
    id_registro, id_bodega, id_empresa,
    activo, condicion
  FROM tb_usuario
  WHERE usuario = ? LIMIT 1
");
$stmt->bind_param('s', $usuario);
$stmt->execute();
$u = $stmt->get_result()->fetch_assoc();

$reason = null;
if (!$u) {
  $reason = 'usuario_no_encontrado';
} elseif ((int)$u['activo'] !== 1 || (int)$u['condicion'] !== 1) {
  $reason = 'usuario_inactivo';
} else {
  //$pass_ok = password_verify($pass, $u['clave']);
  $pass_ok = password_verify($pass, $u['clave']) || hash_equals($u['clave'], $pass);
  // Fallback temporal si aún tienes clave en texto plano (quítalo al migrar a hash):
  // $pass_ok = $pass_ok || $pass === $u['clave'];
  if (!$pass_ok) $reason = 'password_incorrecta';
}

if ($reason) {
  http_response_code(401);
  echo json_encode([
    'success'=>false,
    'message'=>'Credenciales inválidas',
    'reason'=> (DEV ? $reason : null)
  ]);
  exit;
}

echo json_encode([
  'success' => true,
  'user' => [
    'id'          => (int)$u['id'],
    'usuario'     => $u['usuario'],
    'permiso'     => (int)$u['permiso'],
    'id_registro' => (int)($u['id_registro'] ?? 0),
    'id_bodega'   => (int)($u['id_bodega'] ?? 0),
    'id_empresa'  => (int)($u['id_empresa'] ?? 0),
  ]
]);
exit;
