<?php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');

date_default_timezone_set('America/Guayaquil');
$php_now = date('Y-m-d H:i:s T');

$paths = [
  __DIR__ . '/../conex.php',
  __DIR__ . '/../../conex.php',
  dirname(__DIR__, 2) . '/conex.php',
  dirname(__DIR__, 3) . '/conex.php',
];
$found = false;
foreach ($paths as $p) { if (file_exists($p)) { require_once $p; $found = true; break; } }

$info = [
  'php' => ['now'=>$php_now, 'tz'=>date_default_timezone_get(), 'version'=>PHP_VERSION],
  'conex_path_found' => $found,
  'conex_paths_tried' => $paths,
];

if (!$found) { echo json_encode(['success'=>false, 'info'=>$info]); exit; }

$mysqli = $conn ?? ($conex ?? null);
if (!$mysqli instanceof mysqli) {
  $info['mysql'] = ['connected'=>false];
  echo json_encode(['success'=>false, 'info'=>$info, 'message'=>'Conexión MySQL inválida (mysqli no instanciado)']);
  exit;
}
mysqli_set_charset($mysqli, 'utf8mb4');

$mysql_now=null; $tz_session=null; $tz_system=null;
try {
  $q=$mysqli->query("SELECT NOW() AS mysql_now, @@session.time_zone AS session_tz, @@system_time_zone AS system_tz");
  if($q){ $r=$q->fetch_assoc(); $mysql_now=$r['mysql_now']; $tz_session=$r['session_tz']; $tz_system=$r['system_tz']; $q->close(); }
}catch(Throwable $e){ $mysql_now='ERROR: '.$e->getMessage(); }

$tables=[];
foreach(['tb_anden','tb_datadai_anden','tb_datadai'] as $t){
  try{ $qq=$mysqli->query("SHOW TABLES LIKE '$t'"); $tables[$t]=($qq && $qq->num_rows>0); if($qq)$qq->close();
  }catch(Throwable $e){ $tables[$t]='ERROR: '.$e->getMessage(); }
}

echo json_encode([
  'success'=>true,
  'info'=>$info,
  'mysql'=>['connected'=>true,'now'=>$mysql_now,'session_tz'=>$tz_session,'system_tz'=>$tz_system],
  'tables'=>$tables
], JSON_UNESCAPED_UNICODE);
