<?php
declare(strict_types=1);
date_default_timezone_set('America/Guayaquil');

/* JSON + CORS */
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Access-Control-Allow-Methods: GET, OPTIONS');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

/* Conexin */
require __DIR__ . '/../conex.php';
if (!$conn instanceof mysqli) {
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>'Error de conexin a BD']); exit;
}
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
$conn->set_charset('utf8mb4');

try {
  // Tabla: tb_novedad(idnovedad, detallenovedad, condicion)
  $sql = "SELECT 
            idnovedad     AS value,
            detallenovedad AS label
          FROM tb_novedad
          WHERE condicion = 1
          ORDER BY detallenovedad ASC";

  $stmt = $conn->prepare($sql);
  $stmt->execute();
  $res = $stmt->get_result();

  $data = [];
  while ($row = $res->fetch_assoc()) {
    $data[] = $row;
  }

  echo json_encode([
    'success' => true,
    'count'   => count($data),
    'data'    => $data
  ], JSON_UNESCAPED_UNICODE);

} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode([
    'success' => false,
    'message' => 'Error al consultar novedades',
    'detail'  => $e->getMessage()
  ], JSON_UNESCAPED_UNICODE);
} finally {
  if (isset($res) && $res instanceof mysqli_result) $res->free();
  if (isset($stmt) && $stmt instanceof mysqli_stmt) $stmt->close();
  if (isset($conn) && $conn instanceof mysqli) $conn->close();
}
