<?php
// views/pages/api_app/bateria_insert_cargalenta.php
// Inserta SOLO: id_datadai (por CHASIS), id_usuario, fecha, hora_inicio, condicion.

declare(strict_types=1);
date_default_timezone_set('America/Guayaquil');

/* ===== HEADERS / CORS ===== */
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

/* ===== BD ===== */
require_once __DIR__ . '/../conex.php';
$db = $conn ?? ($conex ?? null);
if (!$db instanceof mysqli) { http_response_code(500); echo json_encode(['success'=>false,'message'=>'Sin conexión a BD']); exit; }
if (function_exists('mysqli_report')) { mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT); }
mysqli_set_charset($db, 'utf8mb4');
@$db->query("SET time_zone='-05:00'");

/* ===== INPUT ===== */
$raw = file_get_contents('php://input') ?: '';
$in  = json_decode($raw, true);
if (!is_array($in)) { $in = $_POST ?: []; }

$debug = isset($_GET['_debug']) ? 1 : 0;
$S = static function($k,$def=null) use($in){ return isset($in[$k]) && $in[$k] !== '' ? trim((string)$in[$k]) : $def; };
$I = static function($k,$def=null) use($in){ return isset($in[$k]) && $in[$k] !== '' ? (int)$in[$k] : $def; };

/* ===== Parámetros requeridos/opcionales ===== */
// chasis: REQUERIDO (para resolver id_datadai)
$chasis = strtoupper($S('chasis', ''));
if ($chasis === '') { http_response_code(400); echo json_encode(['success'=>false,'message'=>'El parámetro "chasis" es requerido']); exit; }

// id_usuario: requerido si lo quieres forzar, aquí lo tratamos como opcional -> 0 por defecto
$id_usuario = $I('id_usuario', 0);

// fecha/hora_inicio: si no llegan, usar actuales
$fecha       = $S('fecha', date('Y-m-d'));      // YYYY-MM-DD
$hora_inicio = $S('hora_inicio', date('H:i:s')); // HH:MM:SS
if (strlen($hora_inicio) === 5) { $hora_inicio .= ':00'; } // Normaliza HH:MM -> HH:MM:00

// condicion: por defecto 1
$condicion = $I('condicion', 1);

/* ===== Resolver id_datadai por CHASIS ===== */
try {
  $q = $db->prepare("SELECT iddatadai FROM tb_datadai WHERE UPPER(chasis)=? LIMIT 1");
  $q->bind_param('s', $chasis);
  $q->execute();
  $row = $q->get_result()->fetch_assoc();
  $q->close();

  if (!$row) { http_response_code(404); echo json_encode(['success'=>false,'message'=>'Chasis no encontrado']); exit; }
  $id_datadai = (int)$row['iddatadai'];

  /* ===== INSERT SOLO CAMPOS SOLICITADOS =====
     Asegúrate de que tb_bateria tenga estas columnas:
       - id_datadai (INT)
       - id_usuario (INT)
       - fecha (DATE)
       - hora_inicio (TIME)
       - condicion (INT)
  */
  $sql = "INSERT INTO tb_bateria (id_datadai, id_usuario, fecha, hora_inicio, condicion)
          VALUES (?, ?, ?, ?, ?)";
  $st = $db->prepare($sql);
  // Tipos: i (id_datadai) | i (id_usuario) | s (fecha) | s (hora_inicio) | i (condicion) => "iissi"
  $st->bind_param('iissi', $id_datadai, $id_usuario, $fecha, $hora_inicio, $condicion);
  $st->execute();
  $idbateria = $st->insert_id;
  $st->close();

  $resp = [
    'success'   => true,
    'message'   => 'Registro creado',
    'idbateria' => $idbateria,
    'data'      => [
      'id_datadai'  => $id_datadai,
      'chasis'      => $chasis,
      'id_usuario'  => $id_usuario,
      'fecha'       => $fecha,
      'hora_inicio' => $hora_inicio,
      'condicion'   => $condicion
    ]
  ];
  if ($debug) { $resp['_debug'] = ['sql'=>$sql, 'types'=>'iissi']; }
  echo json_encode($resp, JSON_UNESCAPED_UNICODE);

} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode([
    'success' => false,
    'message' => 'No se pudo guardar',
    'error'   => $e->getMessage()
  ], JSON_UNESCAPED_UNICODE);
}
