<?php
// views/pages/api_app/asignar_set_arribado.php
// Actualiza tb_asignar.status = 'ARRIBADO' por id (uno o varios)
// Body (POST JSON o form-data):
//   - id   : int       (opcional si envías ids[])
//   - ids  : [int,...] (opcional; array de IDs)
//   - _debug: '1'      (opcional)

declare(strict_types=1);
date_default_timezone_set('America/Guayaquil');

/* ===== HEADERS / CORS ===== */
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  echo json_encode(['success'=>false,'stage'=>'method','message'=>'Método no permitido; use POST']); exit;
}

/* ===== Conexión BD ===== */
$pathConex = realpath(__DIR__.'/../conex.php') ?: realpath(__DIR__.'/../../conex.php') ?: realpath(__DIR__.'/conex.php');
if (!$pathConex) { http_response_code(500); echo json_encode(['success'=>false,'stage'=>'conn','message'=>'No se encontró conex.php']); exit; }
require_once $pathConex;

$db = $conn ?? ($conex ?? null);
if (!$db instanceof mysqli) { http_response_code(500); echo json_encode(['success'=>false,'stage'=>'conn','message'=>'Sin conexión a BD']); exit; }
if (function_exists('mysqli_report')) { mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT); }
$db->set_charset('utf8mb4');
@$db->query("SET time_zone='-05:00'"); // Guayaquil

/* ===== Helpers ===== */
function fail(int $code, string $msg, array $extra = []): void {
  http_response_code($code);
  echo json_encode(['success'=>false,'stage'=>'validate','message'=>$msg,'data'=>$extra], JSON_UNESCAPED_UNICODE); exit;
}

/* ===== Entrada ===== */
$raw = file_get_contents('php://input') ?: '';
$in  = json_decode($raw, true);
if (!is_array($in)) { $in = $_POST; }

$debug = (string)($in['_debug'] ?? '0') === '1';

$ids = $in['ids'] ?? ($in['id'] ?? null);
if (is_scalar($ids)) $ids = [$ids];
$ids = is_array($ids) ? array_values(array_unique(array_filter(array_map('intval', $ids), fn($x)=>$x>0))) : [];

if (empty($ids)) {
  fail(422, 'Sin IDs a actualizar', $debug ? ['raw'=>$raw, 'keys'=>array_keys($in)] : []);
}

/* ===== Comprobar existencia y estado actual (opcional pero útil) ===== */
$place = implode(',', array_fill(0, count($ids), '?'));
$typeIds = str_repeat('i', count($ids));

$sqlSel = "SELECT id, status FROM tb_asignar WHERE id IN ($place)";
$stS = $db->prepare($sqlSel);
$refs = [ &$typeIds ];
foreach ($ids as $k => &$v) { $refs[] = &$v; }
call_user_func_array([$stS,'bind_param'], $refs);
$stS->execute();
$resS = $stS->get_result();

$existen = [];
$ya_arribado = [];
$pend_actualizar = [];

while ($r = $resS->fetch_assoc()) {
  $existen[] = (int)$r['id'];
  if (strcasecmp((string)$r['status'], 'ARRIBADO') === 0) {
    $ya_arribado[] = (int)$r['id'];
  } else {
    $pend_actualizar[] = (int)$r['id'];
  }
}
$stS->close();

if (empty($existen)) {
  http_response_code(404);
  echo json_encode(['success'=>false,'stage'=>'not_found','message'=>'IDs no existen en tb_asignar','ids'=>$ids], JSON_UNESCAPED_UNICODE);
  exit;
}

/* ===== UPDATE ===== */
$updated = 0;
if (!empty($pend_actualizar)) {
  $place2 = implode(',', array_fill(0, count($pend_actualizar), '?'));
  $type2  = str_repeat('i', count($pend_actualizar));
  $sqlUpd = "UPDATE tb_asignar SET status = 'ARRIBADO' WHERE id IN ($place2) AND status <> 'ARRIBADO'";
  $stU = $db->prepare($sqlUpd);
  $refs2 = [ &$type2 ];
  foreach ($pend_actualizar as $k => &$v) { $refs2[] = &$v; }
  call_user_func_array([$stU,'bind_param'], $refs2);
  $stU->execute();
  $updated = $stU->affected_rows;
  $stU->close();
}

/* ===== Respuesta ===== */
echo json_encode([
  'success'          => true,
  'message'          => $updated > 0 ? 'Status actualizado a ARRIBADO' : 'Sin cambios (ya estaba ARRIBADO)',
  'requested_ids'    => $ids,
  'existing_ids'     => $existen,
  'already_arribado' => $ya_arribado,
  'updated_ids'      => $updated > 0 ? $pend_actualizar : [],
  'updated_count'    => $updated,
  '_debug'           => $debug ? ['raw'=>$raw] : null
], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
