<?php
// api/ubicacion_combo.php — Lista ligera de Ubicaciones (opcional por bodega)
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

session_start();
require_once __DIR__ . '/../conex.php';
mysqli_set_charset($conn,'utf8mb4');

$id_bodega  = (int)($_GET['id_bodega'] ?? 0);
$q          = trim((string)($_GET['q'] ?? ''));
$onlyActive = isset($_GET['onlyActive']) ? (int)$_GET['onlyActive'] : 1;
$limit      = max(1, (int)($_GET['limit'] ?? 500));

$sql = "SELECT u.id_ubicacion, u.id_bodega, u.codigo, u.nombre,
               b.nombre AS bodega_nombre,
               u.activo
        FROM tb_inv_ubicacion u
        JOIN tb_inv_bodega b ON b.id_bodega=u.id_bodega
        WHERE 1=1";

$params = []; $types = '';

if ($id_bodega > 0) {
  $sql .= " AND u.id_bodega = ?";
  $params[] = $id_bodega; $types .= 'i';
}
if ($onlyActive === 1) {
  $sql .= " AND u.activo = 1";
}
if ($q !== '') {
  $sql .= " AND (u.codigo LIKE CONCAT('%',?,'%') OR u.nombre LIKE CONCAT('%',?,'%'))";
  $params[] = $q; $params[] = $q; $types .= 'ss';
}

$sql .= " ORDER BY b.nombre ASC, u.codigo ASC, u.nombre ASC LIMIT ?";
$params[] = $limit; $types .= 'i';

$stmt = mysqli_prepare($conn, $sql);
if ($params) mysqli_stmt_bind_param($stmt, $types, ...$params);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);

$data = [];
while ($row = mysqli_fetch_assoc($res)) {
  $text = "{$row['bodega_nombre']} / {$row['codigo']} {$row['nombre']}";
  $data[] = [
    'id_ubicacion' => (int)$row['id_ubicacion'],
    'id_bodega'    => (int)$row['id_bodega'],
    'codigo'       => $row['codigo'],
    'nombre'       => $row['nombre'],
    'bodega'       => $row['bodega_nombre'],
    'text'         => $text,
    'activo'       => (int)$row['activo'],
  ];
}

echo json_encode(['success'=>true,'data'=>$data]);
