<?php
// api/tarjas_list.php — Lista todas las tarjas de un id_datadai
declare(strict_types=1);
session_start();

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { exit; }

require_once __DIR__ . '/../conex.php';

$db = $conn ?? ($conex ?? null);
if (!$db) {
  echo json_encode(['success' => false, 'message' => 'Sin conexión', 'data' => []]);
  exit;
}

mysqli_set_charset($db, 'utf8mb4');

$idd = (int)($_GET['idd'] ?? $_POST['idd'] ?? 0); // id_datadai
if ($idd <= 0) {
  echo json_encode(['success'=>false, 'message'=>'Parámetro id_datadai inválido', 'data'=>[]]);
  exit;
}

$sql = "SELECT
          t.idtarja,
          t.numerotarja,
          t.numero_auto,
          DATE(t.fecha)    AS fecha,
          t.id_bodega,
          COALESCE(b.sigla, b.nombre) AS bodega,
          t.observacion
        FROM tb_tarja AS t
        LEFT JOIN tb_bodega AS b ON b.idbodega = t.id_bodega
        WHERE t.id_datadai = ?
          AND t.condicion = 1
        ORDER BY t.idtarja DESC";

$stmt = $db->prepare($sql);
if (!$stmt) {
  echo json_encode(['success'=>false, 'message'=>'Prepare error: '.mysqli_error($db), 'data'=>[]]);
  exit;
}
$stmt->bind_param('i', $idd);
$stmt->execute();
$res = $stmt->get_result();

$data = [];
while ($r = $res->fetch_assoc()) {
  $data[] = [
    'idtarja'     => (int)$r['idtarja'],
    'numerotarja' => htmlspecialchars((string)$r['numerotarja'] ?? '', ENT_QUOTES, 'UTF-8'),
    'numero_auto' => htmlspecialchars((string)$r['numero_auto'] ?? '', ENT_QUOTES, 'UTF-8'),
    'fecha'       => htmlspecialchars((string)$r['fecha'] ?? '', ENT_QUOTES, 'UTF-8'),
    'bodega'      => htmlspecialchars((string)$r['bodega'] ?? '', ENT_QUOTES, 'UTF-8'),
    'observacion' => htmlspecialchars((string)$r['observacion'] ?? '', ENT_QUOTES, 'UTF-8'),
  ];
}
$stmt->close();

echo json_encode(['success'=>true, 'data'=>$data]);
