<?php
// api/solicitud_get.php — con tus nombres de campos
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');

session_start();
if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') {
  echo json_encode(['success'=>false,'message'=>'No autorizado']); exit;
}

$pathConex = realpath(__DIR__ . '/../conex.php') ?: realpath(__DIR__ . '/../../conex.php');
if (!$pathConex) { echo json_encode(['success'=>false,'message'=>'No se encontró conex.php']); exit; }
require_once $pathConex;

$db = $conn ?? ($conex ?? null);
if (!$db instanceof mysqli) { echo json_encode(['success'=>false,'message'=>'Sin conexión BD']); exit; }
mysqli_set_charset($db, 'utf8mb4');

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) { echo json_encode(['success'=>false,'message'=>'ID inválido']); exit; }

/*
  NOTA: mantenemos tus nombres de columnas reales y
  ALIAS para que el front reciba las claves que espera.
*/
$sql = "
SELECT
  sp.idsolicitudprevia         AS id,
  sp.id_empresa                AS id_empresa,
  sp.id_localidad              AS id_localidad,
  sp.codigo                    AS codigo,
  sp.anio                      AS anio,
  sp.numero                    AS numero,
  sp.cod_embarque              AS codigo_embarque,
  DATE(sp.fecha)               AS fecha_emision,
  sp.id_categoria              AS id_categoria,
  COALESCE(e.ruc,'')           AS ruc,
  COALESCE(e.razon_social,'')  AS razon_social,

  -- NUEVOS CAMPOS
  COALESCE(sp.pedido,'')       AS pedido,
  COALESCE(sp.naviera,'')      AS naviera,

  COALESCE(ed.numerodai,'')    AS numerodai,
  DATE(ed.fecha)               AS fechae,
  DATE(ed.fecha_v)             AS fechaev,
  ed.id_bodega                 AS id_bodega
FROM tb_solicitudprevia sp
INNER JOIN tb_categoria  cat ON cat.idcategoria = sp.id_categoria
INNER JOIN tb_empresa    e   ON e.idempresa    = sp.id_empresa
INNER JOIN tb_localidad  l   ON l.idlocalidad  = sp.id_localidad
LEFT  JOIN tb_daientrada ed  ON ed.id_solicitudprevia = sp.idsolicitudprevia
WHERE sp.idsolicitudprevia = ? AND sp.condicion = 1
LIMIT 1";

$stmt = $db->prepare($sql);
if (!$stmt) { echo json_encode(['success'=>false,'message'=>'Error de consulta']); exit; }
$stmt->bind_param('i', $id);
$stmt->execute();
$res = $stmt->get_result();
$row = $res->fetch_assoc();
$stmt->close();

if (!$row) { echo json_encode(['success'=>false,'message'=>'No existe la solicitud']); exit; }

echo json_encode(['success'=>true,'data'=>$row]);
