<?php
// api/solicitud_detalle.php — devuelve detalle de tb_datadai por id_solicitudprevia
// ✅ FIX: ahora incluye id en el JSON (id, iddatadai y alias comunes)
declare(strict_types=1);
session_start();

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { exit; }

require_once __DIR__ . '/../conex.php';

$db = $conn ?? ($conex ?? null);
if (!$db) {
  echo json_encode(['success'=>false,'message'=>'Sin conexión','data'=>[]]);
  exit;
}
mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone = '-05:00'");

// idsp puede venir por GET o POST
$idsp = (int)($_GET['idsp'] ?? $_POST['idsp'] ?? 0);
if ($idsp <= 0) {
  echo json_encode(['success'=>false,'message'=>'Parámetro idsp inválido','data'=>[]]);
  exit;
}

// escape seguro para HTML incrustado (botones)
function esc($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

$sql = "SELECT
          d.iddatadai,
          d.item,
          d.marca,
          d.modelo,
          d.chasis,
          d.motor,
          d.color,
          d.fobunitario,
          d.transporte,
          d.seguro,
          d.valoraduana,
          d.id_estado,
          e.descripcion AS estado_text
        FROM tb_datadai AS d
        INNER JOIN tb_estado AS e ON e.idestado = d.id_estado
        WHERE d.condicion = 1
          AND d.id_solicitudprevia = ?
        ORDER BY d.iddatadai ASC";

$stmt = $db->prepare($sql);
if (!$stmt) {
  echo json_encode(['success'=>false, 'message'=>'Prepare error: '.mysqli_error($db), 'data'=>[]]);
  exit;
}
$stmt->bind_param('i', $idsp);
$stmt->execute();
$res = $stmt->get_result();

$data = [];
while ($r = $res->fetch_assoc()) {
  $id = (int)$r['iddatadai'];

  // Botones acción (EDITAR y ELIMINAR)
  $btnEdit = '<button type="button" class="btn btn-warning btn-sm btn-edit"
               data-id="'.$id.'"
               data-item="'.esc($r['item']).'"
               data-marca="'.esc($r['marca']).'"
               data-modelo="'.esc($r['modelo']).'"
               data-chasis="'.esc($r['chasis']).'"
               data-motor="'.esc($r['motor']).'"
               data-color="'.esc($r['color']).'"
               data-fobunitario="'.esc($r['fobunitario']).'"
               data-transporte="'.esc($r['transporte']).'"
               data-seguro="'.esc($r['seguro']).'"
               data-valoraduana="'.esc($r['valoraduana']).'"
               data-id_estado="'.(int)$r['id_estado'].'"
               title="Editar"><i class="fa fa-pen"></i></button>';

  $btnDel = '<button type="button" class="btn btn-danger btn-sm btn-del"
               data-id="'.$id.'"
               data-chasis="'.esc($r['chasis']).'"
               title="Eliminar"><i class="fa fa-trash"></i></button>';

  // ✅ IMPORTANTE: incluir ID y VIN como campos explícitos en el JSON
  //    Además, añadimos algunos alias comunes por compatibilidad con distintos frontends.
  $data[] = [
    // IDs (el frontend puede usar cualquiera de estos)
    'id'          => $id,
    'iddatadai'   => $id,
    'iddet'       => $id,           // alias
    'id_dato'     => $id,           // alias
    'id_unidad'   => $id,           // alias
    'detalle_id'  => $id,           // alias

    // Campos visibles
    'item'         => (string)$r['item'],
    'marca'        => (string)$r['marca'],
    'modelo'       => (string)$r['modelo'],
    'chasis'       => (string)$r['chasis'], // VIN
    'motor'        => (string)$r['motor'],
    'color'        => (string)$r['color'],
    'fobunitario'  => (string)$r['fobunitario'],
    'transporte'   => (string)$r['transporte'],
    'seguro'       => (string)$r['seguro'],
    'valoraduana'  => (string)$r['valoraduana'],
    'estado'       => (string)$r['estado_text'],

    // Columna de acciones como HTML
    'accion'       => $btnEdit.' '.$btnDel,
  ];
}

echo json_encode(['success'=>true,'data'=>$data], JSON_UNESCAPED_UNICODE);
