<?php
// api/requerimiento_vehiculos.php — guarda el detalle (vehículos) de un requerimiento PDI
declare(strict_types=1);
session_start();

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }
if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') {
  http_response_code(401);
  echo json_encode(['success'=>false,'message'=>'No autorizado']); exit;
}

require_once __DIR__ . '/../conex.php';
$db = $conn ?? ($conex ?? null);
if (!$db) { http_response_code(500); echo json_encode(['success'=>false,'message'=>'Sin conexión BD']); exit; }
mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone = '-05:00'");

$input = json_decode(file_get_contents('php://input'), true) ?: [];
$id_requerimiento = (int)($input['id_requerimiento'] ?? 0);
$vehiculos        = $input['vehiculos'] ?? [];

if ($id_requerimiento <= 0 || !is_array($vehiculos) || count($vehiculos) === 0) {
  echo json_encode(['success'=>false,'message'=>'Parámetros inválidos']); exit;
}

// Sugerencia de detalle (si usas tb_pdi como detalle):
// ALTER TABLE tb_pdi ADD COLUMN id_requerimiento INT NULL;
// CREATE INDEX idx_pdi_req ON tb_pdi(id_requerimiento);
//
// Campos típicos de tb_pdi (según tus notas previas):
// tb_pdi (idpdi, id_datadai, alistamiento, requerido, entrega, ...)
// Aquí guardaremos filas por vehículo referenciando el id_requerimiento.

mysqli_begin_transaction($db);
try {
  $sql = "INSERT INTO tb_pdi
          (id_requerimiento, id_datadai, condicion)
          VALUES (?, ?, 1)";
  $stmt = mysqli_prepare($db, $sql);
  if (!$stmt) { throw new Exception('Error prepare detalle'); }

  foreach ($vehiculos as $v) {
    $idd = (int)($v['iddatadai'] ?? 0);
    if ($idd <= 0) continue;
    mysqli_stmt_bind_param($stmt, 'ii', $id_requerimiento, $idd);
    if (!mysqli_stmt_execute($stmt)) {
      throw new Exception('Error insert detalle');
    }
  }

  mysqli_commit($db);
  echo json_encode(['success'=>true]);
} catch (Throwable $e) {
  mysqli_rollback($db);
  echo json_encode(['success'=>false,'message'=>$e->getMessage()]);
}
