<?php
// api/requerimiento_guardar.php — Inserta N filas en tb_adi (una por vehículo)
declare(strict_types=1);
session_start();

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') {
  echo json_encode(['success'=>false,'message'=>'No autorizado']); exit;
}

require_once __DIR__ . '/../conex.php';
$db = $conn ?? ($conex ?? null);
if (!$db) { echo json_encode(['success'=>false,'message'=>'Sin conexión BD']); exit; }
mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone = '-05:00'");

// === Helper: validar y normalizar datetime (de 'YYYY-MM-DDTHH:MM' a 'YYYY-MM-DD HH:MM:SS')
function to_mysql_datetime(string $s): string {
  $s = trim($s);
  if ($s === '') return '';
  $s = str_replace('T',' ', $s);
  if (preg_match('/^\d{4}-\d{2}-\d{2} \d{2}:\d{2}$/', $s)) { $s .= ':00'; }
  if (!preg_match('/^\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}$/', $s)) return '';
  return $s;
}

$in = json_decode(file_get_contents('php://input'), true) ?: [];
$header    = $in['header']    ?? null;
$vehiculos = $in['vehiculos'] ?? null;

if (!is_array($header) || !is_array($vehiculos) || count($vehiculos) === 0) {
  echo json_encode(['success'=>false,'message'=>'Parámetros inválidos']); exit;
}

/*
  tb_adi (según indicaste)
  idpdi INT AI PK,
  id_datadai INT,
  alistamiento VARCHAR(?),
  requerimiento DATETIME,
  entrega DATETIME,
  requerido VARCHAR(?),
  condicion TINYINT,
  prioridad ENUM('NORMAL','URGENTE') o VARCHAR(?),
  facturado VARCHAR(?)
*/

$alistamiento = trim((string)($header['alistamiento'] ?? ''));
$requerido    = trim((string)($header['requerido'] ?? ''));
$requerimiento= to_mysql_datetime((string)($header['requerimiento'] ?? ''));
$entrega      = to_mysql_datetime((string)($header['entrega'] ?? ''));
$prioridad    = strtoupper(trim((string)($header['prioridad'] ?? 'NORMAL')));
$facturado    = trim((string)($header['facturado'] ?? ''));

if ($alistamiento==='' || $requerido==='' || $requerimiento==='' || $entrega==='' || $facturado==='') {
  echo json_encode(['success'=>false,'message'=>'Datos de cabecera incompletos o fecha inválida']); exit;
}
if ($prioridad !== 'URGENTE') $prioridad = 'NORMAL';

mysqli_begin_transaction($db);
try {
  $sql = "INSERT INTO tb_adi
          (id_datadai, alistamiento, requerimiento, entrega, requerido, condicion, prioridad, facturado)
          VALUES (?, ?, ?, ?, ?, 1, ?, ?)";
  $stmt = mysqli_prepare($db, $sql);
  if (!$stmt) { throw new Exception('Error prepare: '.mysqli_error($db)); }

  $insertados = 0;
  foreach ($vehiculos as $v) {
    $idd = (int)($v['iddatadai'] ?? 0);
    if ($idd <= 0) { continue; }
    mysqli_stmt_bind_param($stmt, 'issssss',
      $idd, $alistamiento, $requerimiento, $entrega, $requerido, $prioridad, $facturado
    );
    if (!mysqli_stmt_execute($stmt)) {
      throw new Exception('Error insert: '.mysqli_error($db));
    }
    $insertados++;
  }

  if ($insertados === 0) { throw new Exception('No hay vehículos válidos para guardar.'); }

  mysqli_commit($db);
  echo json_encode(['success'=>true,'insertados'=>$insertados]);
} catch (Throwable $e) {
  mysqli_rollback($db);
  echo json_encode(['success'=>false,'message'=>'No se pudo guardar','sql_error'=>$e->getMessage()]);
}
