<?php
// pdi_update_lavada.php — Actualiza tb_lavada.id_tipolavada por idlavada
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

session_start();
if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') {
  http_response_code(401);
  echo json_encode(['success'=>false,'message'=>'No autorizado']); exit;
}

require_once __DIR__ . '/../conex.php';
$db = $conn ?? ($conex ?? null);
if (!$db) { echo json_encode(['success'=>false,'message'=>'Sin conexión']); exit; }
mysqli_set_charset($db, 'utf8mb4');

$in = json_decode(file_get_contents('php://input'), true);

$idlavada = (int)($in['idlavada'] ?? 0);
$idtipo_lavada = $in['idtipo_lavada'] ?? null;
$idtipo_lavada = ($idtipo_lavada === '' || $idtipo_lavada === null) ? null : (int)$idtipo_lavada;

if ($idlavada <= 0) {
  http_response_code(422);
  echo json_encode(['success'=>false,'message'=>'idlavada inválido']);
  exit;
}

try {
  $sql = "UPDATE tb_lavada SET id_tipolavada = ? WHERE idlavada = ? LIMIT 1";
  $st = mysqli_prepare($db, $sql);
  if (!$st) throw new RuntimeException('No se pudo preparar UPDATE');

  // Si $idtipo_lavada es null, lo guardamos como NULL
  // bind_param no admite null directo; usamos 'ii' y seteamos null como 0? Mejor usar set a NULL con lógica separada:
  if ($idtipo_lavada === null) {
    // Establecer NULL explícito
    $sqlNull = "UPDATE tb_lavada SET id_tipolavada = NULL WHERE idlavada = ? LIMIT 1";
    $stNull = mysqli_prepare($db, $sqlNull);
    if (!$stNull) throw new RuntimeException('No se pudo preparar UPDATE NULL');
    mysqli_stmt_bind_param($stNull, 'i', $idlavada);
    if (!mysqli_stmt_execute($stNull)) throw new RuntimeException('No se pudo actualizar (NULL)');
    mysqli_stmt_close($stNull);
  } else {
    mysqli_stmt_bind_param($st, 'ii', $idtipo_lavada, $idlavada);
    if (!mysqli_stmt_execute($st)) throw new RuntimeException('No se pudo actualizar');
    mysqli_stmt_close($st);
  }

  echo json_encode(['success'=>true]);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>$e->getMessage()]);
}
