<?php
// api/parte_save.php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

session_start();
require_once __DIR__ . '/../conex.php';
mysqli_set_charset($conn, 'utf8mb4');

$in = json_decode(file_get_contents('php://input'), true);
$id_parte  = (int)($in['id_parte'] ?? 0);
$nombre    = trim((string)($in['nombre'] ?? ''));
$condicion = isset($in['condicion']) ? (int)$in['condicion'] : 1;

if ($nombre === '') { echo json_encode(['success'=>false,'message'=>'El nombre es obligatorio']); exit; }
$condicion = ($condicion===0?0:1);

if ($id_parte > 0) {
  $stmt = mysqli_prepare($conn, "UPDATE tb_inv_parte SET nombre=?, condicion=? WHERE id_parte=?");
  mysqli_stmt_bind_param($stmt, 'sii', $nombre, $condicion, $id_parte);
  $ok = mysqli_stmt_execute($stmt);
  if (!$ok) {
    $err = mysqli_error($conn);
    if (str_contains($err, 'uq_parte_nombre')) {
      echo json_encode(['success'=>false,'message'=>'Ya existe una parte con ese nombre']); exit;
    }
    echo json_encode(['success'=>false,'message'=>'Error al actualizar']); exit;
  }
  echo json_encode(['success'=>true,'message'=>'Actualizado']);
} else {
  $stmt = mysqli_prepare($conn, "INSERT INTO tb_inv_parte (nombre, condicion) VALUES (?,?)");
  mysqli_stmt_bind_param($stmt, 'si', $nombre, $condicion);
  $ok = mysqli_stmt_execute($stmt);
  if (!$ok) {
    $err = mysqli_error($conn);
    if (str_contains($err, 'uq_parte_nombre')) {
      echo json_encode(['success'=>false,'message'=>'Ya existe una parte con ese nombre']); exit;
    }
    echo json_encode(['success'=>false,'message'=>'Error al crear']); exit;
  }
  echo json_encode(['success'=>true,'message'=>'Creado','id'=>mysqli_insert_id($conn)]);
}
