<?php
// api/movimiento_get.php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }
session_start();
require_once __DIR__ . '/../conex.php';
mysqli_set_charset($conn,'utf8mb4');

$id = (int)($_GET['id'] ?? 0);
if ($id<=0){ echo json_encode(['success'=>false,'message'=>'ID inválido']); exit; }

$stmt = mysqli_prepare($conn,"SELECT id_movimiento, fecha, tipo, id_bodega_origen, id_bodega_destino, motivo, ref_tipo, ref_id, id_usuario FROM tb_inv_movimiento WHERE id_movimiento=?");
mysqli_stmt_bind_param($stmt,'i',$id);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);
$mov = mysqli_fetch_assoc($res);
if (!$mov){ echo json_encode(['success'=>false,'message'=>'No encontrado']); exit; }

$det=[];
$q = "SELECT d.id_movimiento_det, d.id_accesorio, a.sku, a.nombre AS accesorio, d.cantidad, d.id_ubicacion
      FROM tb_inv_movimiento_det d
      JOIN tb_inv_accesorio a ON a.id_accesorio=d.id_accesorio
      WHERE d.id_movimiento={$id}
      ORDER BY d.id_movimiento_det ASC";
$r = mysqli_query($conn,$q);
while($x=mysqli_fetch_assoc($r)) $det[]=$x;

echo json_encode(['success'=>true,'data'=>['cab'=>$mov,'det'=>$det]]);
