<?php
// api/movimiento_delete.php — Revierte stock y borra movimiento + detalle
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

session_start();
require_once __DIR__ . '/../conex.php';
mysqli_set_charset($conn,'utf8mb4');

function lock_stock_row(mysqli $c, int $id_bod, int $id_acc, ?int $id_ubi): array {
  $sql = "SELECT id_stock, stock FROM tb_inv_stock
          WHERE id_bodega=? AND id_accesorio=? AND IFNULL(id_ubicacion,0)=IFNULL(?,0)
          FOR UPDATE";
  $st = mysqli_prepare($c,$sql);
  mysqli_stmt_bind_param($st,'iii',$id_bod,$id_acc,$id_ubi);
  mysqli_stmt_execute($st);
  $res = mysqli_stmt_get_result($st);
  $row = mysqli_fetch_assoc($res);
  if ($row) return $row;

  $ins = mysqli_prepare($c,"INSERT INTO tb_inv_stock (id_bodega,id_accesorio,id_ubicacion,stock) VALUES (?,?,?,0)
                            ON DUPLICATE KEY UPDATE stock=stock");
  mysqli_stmt_bind_param($ins,'iii',$id_bod,$id_acc,$id_ubi);
  mysqli_stmt_execute($ins);

  mysqli_stmt_execute($st);
  $res = mysqli_stmt_get_result($st);
  return mysqli_fetch_assoc($res);
}
function apply_stock_delta(mysqli $c, int $id_bod, int $id_acc, ?int $id_ubi, float $delta, string $ctx=''){
  $row = lock_stock_row($c,$id_bod,$id_acc,$id_ubi);
  $nuevo = (float)$row['stock'] + $delta;
  if ($nuevo < -1e-9) throw new Exception("Stock insuficiente al revertir ($ctx).");
  $upd = mysqli_prepare($c,"UPDATE tb_inv_stock SET stock=? WHERE id_stock=?");
  mysqli_stmt_bind_param($upd,'di',$nuevo,$row['id_stock']);
  mysqli_stmt_execute($upd);
}

$in = json_decode(file_get_contents('php://input'), true);
$id = (int)($in['id_movimiento'] ?? 0);
if ($id<=0){ echo json_encode(['success'=>false,'message'=>'ID inválido']); exit; }

try{
  mysqli_begin_transaction($conn);

  // Cabecera con lock
  $st = mysqli_prepare($conn,"SELECT * FROM tb_inv_movimiento WHERE id_movimiento=? FOR UPDATE");
  mysqli_stmt_bind_param($st,'i',$id);
  mysqli_stmt_execute($st);
  $res = mysqli_stmt_get_result($st);
  $cab = mysqli_fetch_assoc($res);
  if (!$cab) throw new Exception('Movimiento no encontrado');

  $det = [];
  $r = mysqli_query($conn,"SELECT id_movimiento_det, id_accesorio, cantidad, id_ubicacion FROM tb_inv_movimiento_det WHERE id_movimiento={$id}");
  while($x=mysqli_fetch_assoc($r)) $det[]=$x;

  // Revertir stock
  $tipo = $cab['tipo'];
  $id_o = (int)$cab['id_bodega_origen'];
  $id_d = (int)$cab['id_bodega_destino'];
  foreach($det as $row){
    $acc=(int)$row['id_accesorio']; $can=(float)$row['cantidad']; $ubi = $row['id_ubicacion']!==null ? (int)$row['id_ubicacion'] : null;
    if ($tipo==='IN'){
      apply_stock_delta($conn,$id_d,$acc,$ubi,-$can,'REVERSA ENTRADA');
    } elseif ($tipo==='OUT'){
      apply_stock_delta($conn,$id_o,$acc,$ubi,+$can,'REVERSA SALIDA');
    } else {
      apply_stock_delta($conn,$id_o,$acc,$ubi,+$can,'REVERSA TRF origen');
      apply_stock_delta($conn,$id_d,$acc,$ubi,-$can,'REVERSA TRF destino');
    }
  }

  // Eliminar detalle + cabecera
  mysqli_query($conn,"DELETE FROM tb_inv_movimiento_det WHERE id_movimiento={$id}");
  mysqli_query($conn,"DELETE FROM tb_inv_movimiento WHERE id_movimiento={$id}");

  mysqli_commit($conn);
  echo json_encode(['success'=>true,'message'=>'Eliminado y stock revertido']);

} catch(Throwable $e){
  mysqli_rollback($conn);
  http_response_code(400);
  echo json_encode(['success'=>false,'message'=>$e->getMessage()]);
}
