<?php
// api/monedas_list.php — lista de monedas para el <select>
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/../conex.php';
$db = $conn ?? ($conex ?? null);
if (!$db) { echo json_encode(['data'=>[], 'message'=>'Sin conexión']); exit; }

mysqli_set_charset($db, 'utf8mb4');

$sql = "SELECT idmoneda, detalle, siglas, simbolo
        FROM tb_moneda
        WHERE condicion = 1
        ORDER BY detalle ASC";
$res = mysqli_query($db, $sql);
if (!$res) {
  echo json_encode(['data'=>[], 'message'=>'Error SQL: '.mysqli_error($db)]);
  exit;
}

$data = [];
while ($row = mysqli_fetch_assoc($res)) {
  $data[] = [
    'idmoneda' => (int)$row['idmoneda'],
    'detalle'  => (string)$row['detalle'],
    'siglas'   => (string)($row['siglas'] ?? ''),
    'simbolo'  => (string)($row['simbolo'] ?? ''),
    // Etiqueta concatenada:
    'text'     => trim($row['detalle'].' ('.($row['siglas'] ?? '').')')
  ];
}
echo json_encode(['data'=>$data], JSON_UNESCAPED_UNICODE);
