<?php
// api/marca_delete.php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

session_start();
require_once __DIR__ . '/../conex.php';
mysqli_set_charset($conn,'utf8mb4');

$in = json_decode(file_get_contents('php://input'), true);
$id = (int)($in['id_marca'] ?? 0);
$hard = (int)($in['hard'] ?? 0);
if ($id <= 0) { echo json_encode(['success'=>false,'message'=>'ID inválido']); exit; }

if ($hard === 1) {
  $stmt = mysqli_prepare($conn,"DELETE FROM tb_inv_marca WHERE id_marca=?");
  mysqli_stmt_bind_param($stmt,'i',$id);
} else {
  $stmt = mysqli_prepare($conn,"UPDATE tb_inv_marca SET condicion=0 WHERE id_marca=?");
  mysqli_stmt_bind_param($stmt,'i',$id);
}
$ok = mysqli_stmt_execute($stmt);
if (!$ok) { echo json_encode(['success'=>false,'message'=>'No se pudo eliminar']); exit; }

echo json_encode(['success'=>true,'message'=> $hard ? 'Eliminado' : 'Inactivado' ]);
