<?php
// api/lugares_list.php — Lista de lugares para <select>
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

require_once __DIR__ . '/../conex.php';

try {
    if (!isset($conn) || !($conn instanceof mysqli)) {
        throw new RuntimeException('Sin conexión BD');
    }
    mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
    mysqli_set_charset($conn, 'utf8mb4');

    // Ajusta nombres de columnas si difieren (id, nombre/descripcion/…)
    $sql = "SELECT id, lugar FROM tb_lugar WHERE activo = 1 ORDER BY lugar ASC";
    $rs  = $conn->query($sql);

    $data = [];
    while ($r = $rs->fetch_assoc()) {
        $data[] = [
            'id'     => (string)$r['id'],
            'nombre' => (string)$r['lugar'],
        ];
    }

    echo json_encode(['success' => true, 'data' => $data], JSON_UNESCAPED_UNICODE);
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
