<?php
// api/incidente_flag_guardar.php
// Actualiza flags no_repara / no_aplica en tb_incidente

declare(strict_types=1);
session_start();

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
  http_response_code(204);
  exit;
}

date_default_timezone_set('America/Guayaquil');

try {
  if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') {
    http_response_code(401);
    echo json_encode([
      'success' => false,
      'message' => 'Sesión no válida'
    ]);
    exit;
  }

  require_once __DIR__ . '/../conex.php';

  $db = $conn ?? ($conex ?? null);
  if (!$db instanceof mysqli) {
    echo json_encode([
      'success' => false,
      'message' => 'Sin conexión a la base de datos'
    ]);
    exit;
  }

  if (function_exists('mysqli_report')) {
    mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
  }

  mysqli_set_charset($db, 'utf8mb4');
  @mysqli_query($db, "SET time_zone = '-05:00'");

  $raw = file_get_contents('php://input');
  $data = json_decode($raw ?: '', true);
  if (!is_array($data)) {
    $data = $_POST;
  }

  $incident_id = isset($data['incident_id']) ? (int)$data['incident_id'] : 0;
  $campo       = isset($data['campo']) ? trim((string)$data['campo']) : '';
  $valor       = isset($data['valor']) ? (int)$data['valor'] : 0;
  $valor       = $valor ? 1 : 0;

  $camposPermitidos = ['no_repara', 'no_aplica'];

  if ($incident_id <= 0) {
    http_response_code(400);
    echo json_encode([
      'success' => false,
      'message' => 'incident_id inválido'
    ]);
    exit;
  }

  if (!in_array($campo, $camposPermitidos, true)) {
    http_response_code(400);
    echo json_encode([
      'success' => false,
      'message' => 'Campo no permitido. Use no_repara o no_aplica.'
    ]);
    exit;
  }

  $sqlCheck = "SELECT idincidente, no_repara, no_aplica
               FROM tb_incidente
               WHERE idincidente = ?";
  $stmt = $db->prepare($sqlCheck);
  $stmt->bind_param('i', $incident_id);
  $stmt->execute();
  $res = $stmt->get_result();
  $row = $res->fetch_assoc();
  $stmt->close();

  if (!$row) {
    http_response_code(404);
    echo json_encode([
      'success' => false,
      'message' => 'Incidente no encontrado'
    ]);
    exit;
  }

  $sqlUpdate = "UPDATE tb_incidente
                SET $campo = ?
                WHERE idincidente = ?";

  $stmt = $db->prepare($sqlUpdate);
  $stmt->bind_param('ii', $valor, $incident_id);
  $stmt->execute();
  $stmt->close();

  echo json_encode([
    'success'      => true,
    'message'      => 'Flag actualizado correctamente',
    'incident_id'  => $incident_id,
    'campo'        => $campo,
    'valor'        => $valor
  ]);

} catch (mysqli_sql_exception $e) {
  http_response_code(500);
  echo json_encode([
    'success'   => false,
    'message'   => 'Error SQL al actualizar flag',
    'sql_error' => $e->getMessage()
  ]);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode([
    'success' => false,
    'message' => 'Error interno al actualizar flag',
    'error'   => $e->getMessage()
  ]);
}
