<?php
declare(strict_types=1);
session_start();
date_default_timezone_set('America/Guayaquil');
header('Content-Type: application/json; charset=utf-8');

if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') {
  http_response_code(401);
  echo json_encode(['success'=>false,'message'=>'No autorizado']); exit;
}
require_once __DIR__ . '/../conex.php';
if (!isset($conn) || !$conn instanceof mysqli) {
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>'Sin conexión a BD']); exit;
}
mysqli_set_charset($conn, 'utf8mb4');

$id = isset($_POST['idempresa']) ? (int)$_POST['idempresa'] : 0;
$estado = isset($_POST['estado']) ? (int)$_POST['estado'] : null;

if ($id<=0 || ($estado!==0 && $estado!==1)) {
  http_response_code(400);
  echo json_encode(['success'=>false,'message'=>'Parámetros inválidos']); exit;
}
try{
  if (function_exists('mysqli_report')) { mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT); }
  $stmt = $conn->prepare("UPDATE tb_empresa SET estado=? WHERE idempresa=?");
  $stmt->bind_param('ii',$estado,$id);
  $stmt->execute(); $af = $stmt->affected_rows; $stmt->close();
  echo json_encode(['success'=>true,'message'=>$af>0 ? 'Estado actualizado' : 'Sin cambios','data'=>['idempresa'=>$id,'estado'=>$estado]]);
}catch(Throwable $e){
  http_response_code(500);
  echo json_encode(['success'=>false,'message'=>'Error al actualizar estado','error'=>$e->getMessage()]);
}
