<?php
// api/directa_list.php — Lista de DAI listos (todos sus items en estado 3) SIN validar permisos
declare(strict_types=1);
session_start();

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

/* ==== Cargar conex.php de forma robusta ==== */
$pathConex = null;
foreach ([__DIR__.'/conex.php', dirname(__DIR__).'/conex.php', __DIR__.'/../conex.php'] as $p) {
  if (is_file($p)) { $pathConex = $p; break; }
}
if (!$pathConex) {
  echo json_encode(['success'=>false,'message'=>'No se encontró conex.php','data'=>[]]);
  exit;
}
require_once $pathConex;

/* ==== Conexión ==== */
$db = $conn ?? ($conex ?? null);
if (!$db) {
  echo json_encode(['success'=>false,'message'=>'Sin conexión a la base de datos','data'=>[]]);
  exit;
}
mysqli_set_charset($db, 'utf8mb4');
@mysqli_query($db, "SET time_zone='-05:00'");

/**
 * Consulta:
 *  - Une DAI (e), Solicitud Previa (s), Empresa (c), Items (d)
 *  - d.condicion = 1 y d.dai <> 'Simple' (case-insensitive, sin espacios)
 *  - cantidad: total de items; cantidad_e: items con id_estado=3
 *  - HAVING: cantidad > 0 y cantidad = cantidad_e (todos listos)
 *  - SIN filtrar por permisos/usuario
 */
$sql = "
  SELECT
    e.iddaientrada                                   AS iddaientrada,
    e.numerodai                                      AS numerodai,
    c.ruc                                            AS ruc,
    c.razon_social                                   AS razon_social,
    COUNT(d.iddatadai)                               AS cantidad,
    SUM(CASE WHEN d.id_estado < 8 THEN 1 ELSE 0 END) AS cantidad_e
  FROM tb_daientrada e
  JOIN tb_solicitudprevia s ON s.idsolicitudprevia = e.id_solicitudprevia AND s.condicion = 1
  JOIN tb_empresa c         ON c.idempresa = s.id_empresa
  JOIN tb_datadai d         ON d.id_daientrada = e.iddaientrada
  WHERE e.condicion = 1
    AND d.condicion = 1
    AND TRIM(UPPER(d.dai)) <> 'SIMPLE'
  GROUP BY e.iddaientrada, e.numerodai, c.ruc, c.razon_social
  HAVING cantidad > 0 AND cantidad = cantidad_e
  ORDER BY e.iddaientrada DESC
";

$res = mysqli_query($db, $sql);
if (!$res) {
  echo json_encode(['success'=>false,'message'=>'Error SQL: '.mysqli_error($db),'data'=>[]]);
  exit;
}

$rows = [];
while ($r = mysqli_fetch_assoc($res)) {
  $rows[] = [
    'dai70'      => (string)($r['numerodai'] ?? ''),
    'ruc'        => (string)($r['ruc'] ?? ''),
    'importador' => (string)($r['razon_social'] ?? ''),
    'items'      => (int)($r['cantidad'] ?? 0),
    'accion'     => sprintf(
                      '<a href="daidirecta.php?iddaien=%d" class="btn btn-primary btn-sm" data-bs-toggle="tooltip" title="Ver DAI"><i class="fa-solid fa-cube"></i></a>',
                      (int)$r['iddaientrada']
                    ),
    // Compat opcional con front antiguo:
    'fecha'      => (string)($r['numerodai'] ?? ''),
    'razon'      => (string)($r['razon_social'] ?? ''),
    'cantidad'   => (int)($r['cantidad'] ?? 0),
    // Útil para estilos de fila en DataTable si lo necesitas:
    'estado'     => 3,
  ];
}

echo json_encode(['success'=>true,'data'=>$rows], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
