<?php
// api/datadai_update.php — actualiza TODO menos id_estado
declare(strict_types=1);
session_start();
header('Content-Type: application/json; charset=utf-8');

require_once __DIR__ . '/../conex.php';

$db = $conn ?? ($conex ?? null);
if (!$db) {
  echo json_encode(['success'=>false,'message'=>'Sin conexión']); exit;
}
mysqli_set_charset($db, 'utf8mb4');

$id            = (int)($_POST['id'] ?? 0);
$item          = trim($_POST['item'] ?? '');
$marca         = trim($_POST['marca'] ?? '');
$modelo        = trim($_POST['modelo'] ?? '');
$chasis        = trim($_POST['chasis'] ?? '');
$motor         = trim($_POST['motor'] ?? '');
$color         = trim($_POST['color'] ?? '');
$fobunitario   = trim($_POST['fobunitario'] ?? '');
$transporte    = trim($_POST['transporte'] ?? '');
$seguro        = trim($_POST['seguro'] ?? '');
$valoraduana   = trim($_POST['valoraduana'] ?? '');

// helper num
$norm = function($v){
  $s = trim((string)$v);
  if ($s==='') return '0';
  if (strpos($s, ',') !== false && strpos($s, '.') !== false) {
    $s = str_replace('.', '', $s);
    $s = str_replace(',', '.', $s);
  } elseif (strpos($s, ',') !== false) {
    $s = str_replace(',', '.', $s);
  }
  return is_numeric($s) ? $s : '0';
};

$fobunitario = $norm($fobunitario);
$transporte  = $norm($transporte);
$seguro      = $norm($seguro);
$valoraduana = $norm($valoraduana);

if ($id <= 0) { echo json_encode(['success'=>false,'message'=>'ID inválido']); exit; }
if ($chasis === '') { echo json_encode(['success'=>false,'message'=>'Chasis requerido']); exit; }

// (Opcional) Verificar duplicado de chasis en otra fila activa
$dupSql = "SELECT 1 FROM tb_datadai WHERE chasis=? AND condicion=1 AND iddatadai<>?";
$dup = $db->prepare($dupSql);
$dup->bind_param('si', $chasis, $id);
$dup->execute();
$dup->store_result();
if ($dup->num_rows > 0) {
  echo json_encode(['success'=>false,'message'=>'Ya existe otra unidad con ese chasis']); exit;
}
$dup->close();

// UPDATE (sin tocar id_estado)
$sql = "UPDATE tb_datadai
        SET item=?, marca=?, modelo=?, chasis=?, motor=?, color=?,
            fobunitario=?, transporte=?, seguro=?, valoraduana=?
        WHERE iddatadai=? AND condicion=1";
$stmt = $db->prepare($sql);
if (!$stmt) {
  echo json_encode(['success'=>false,'message'=>'Prepare error: '.mysqli_error($db)]); exit;
}
$stmt->bind_param(
  'ssssssssssi',
  $item, $marca, $modelo, $chasis, $motor, $color,
  $fobunitario, $transporte, $seguro, $valoraduana,
  $id
);
if (!$stmt->execute()) {
  echo json_encode(['success'=>false,'message'=>'Error al actualizar: '.$stmt->error]); exit;
}
echo json_encode(['success'=>true]);
