<?php
session_start();
header('Content-Type: application/json');
include("../conex.php");

$id_usuario = $_SESSION['idusuario'] ?? 0;

$sql = "
SELECT DISTINCT d.iddatadai, e.numerodai, e.fecha, e.fecha_v, d.id_estado, d.marca, d.modelo, d.chasis, d.motor, d.color
FROM tb_datadai AS d
INNER JOIN tb_solicitudprevia AS sp ON sp.idsolicitudprevia = d.id_solicitudprevia
INNER JOIN tb_daientrada AS e ON e.iddaientrada = d.id_daientrada
WHERE 
  d.condicion = 1 
  AND sp.condicion = 1
  AND d.dai <> 'Simple'
  AND d.id_estado BETWEEN 2 AND 8
  AND d.id_bodega = 2
";

$result = mysqli_query($conn, $sql);

$data = [];
while ($row = mysqli_fetch_assoc($result)) {
    $data[] = [
        'dai'     => $row['numerodai'],
        'inicio'  => $row['fecha'],
        'fin'     => $row['fecha_v'],
        'marca'   => $row['marca'],
        'modelo'  => $row['modelo'],
        'chasis'  => $row['chasis'],
        'motor'   => $row['motor'],
        'color'   => $row['color']
    ];
}

echo json_encode(['data' => $data]);
