<?php
// api/bodega_save.php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

session_start();
require_once __DIR__ . '/../conex.php';
mysqli_set_charset($conn,'utf8mb4');

$in = json_decode(file_get_contents('php://input'), true);
$id_bodega = (int)($in['id_bodega'] ?? 0);
$nombre    = trim((string)($in['nombre'] ?? ''));
$ciudad    = trim((string)($in['ciudad'] ?? ''));
$direccion = trim((string)($in['direccion'] ?? ''));
$activo    = isset($in['activo']) ? (int)$in['activo'] : 1;
$condicion = isset($in['condicion']) ? (int)$in['condicion'] : 1;

if ($nombre === '' || $ciudad === '' || $direccion === '') {
  echo json_encode(['success'=>false,'message'=>'Nombre, ciudad y dirección son obligatorios']); exit;
}
$activo    = ($activo===0?0:1);
$condicion = ($condicion===0?0:1);

if ($id_bodega > 0) {
  $stmt = mysqli_prepare($conn,"UPDATE tb_inv_bodega SET nombre=?, ciudad=?, direccion=?, activo=?, condicion=? WHERE id_bodega=?");
  mysqli_stmt_bind_param($stmt,'sssiii',$nombre,$ciudad,$direccion,$activo,$condicion,$id_bodega);
  $ok = mysqli_stmt_execute($stmt);
  if (!$ok) {
    $err = mysqli_error($conn);
    if (str_contains($err,'uq_bodega_nombre_ciudad')) {
      echo json_encode(['success'=>false,'message'=>'Ya existe una bodega con ese nombre en esa ciudad']); exit;
    }
    echo json_encode(['success'=>false,'message'=>'Error al actualizar']); exit;
  }
  echo json_encode(['success'=>true,'message'=>'Actualizado']);
} else {
  $stmt = mysqli_prepare($conn,"INSERT INTO tb_inv_bodega (nombre, ciudad, direccion, activo, condicion) VALUES (?,?,?,?,?)");
  mysqli_stmt_bind_param($stmt,'sssii',$nombre,$ciudad,$direccion,$activo,$condicion);
  $ok = mysqli_stmt_execute($stmt);
  if (!$ok) {
    $err = mysqli_error($conn);
    if (str_contains($err,'uq_bodega_nombre_ciudad')) {
      echo json_encode(['success'=>false,'message'=>'Ya existe una bodega con ese nombre en esa ciudad']); exit;
    }
    echo json_encode(['success'=>false,'message'=>'Error al crear']); exit;
  }
  echo json_encode(['success'=>true,'message'=>'Creado','id'=>mysqli_insert_id($conn)]);
}
