<?php
// api/bodega_get.php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

session_start();
require_once __DIR__ . '/../conex.php';
mysqli_set_charset($conn,'utf8mb4');

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) { echo json_encode(['success'=>false,'message'=>'ID inválido']); exit; }

$stmt = mysqli_prepare($conn,"SELECT id_bodega, nombre, ciudad, direccion, IFNULL(activo,1) AS activo, IFNULL(condicion,1) AS condicion FROM tb_inv_bodega WHERE id_bodega=?");
mysqli_stmt_bind_param($stmt,'i',$id);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);
$row = mysqli_fetch_assoc($res);

if (!$row) { echo json_encode(['success'=>false,'message'=>'No encontrado']); exit; }
echo json_encode(['success'=>true,'data'=>$row]);
