<?php
// api/bateria_historial.php — historial por id_datadai (o por chasis)
declare(strict_types=1);

session_start();
header('Content-Type: application/json; charset=utf-8');
require_once __DIR__ . '/../conex.php';

if (!isset($conn) || !$conn) {
  echo json_encode(['data'=>[], 'error'=>'Error de conexión a la base de datos']); exit;
}
mysqli_set_charset($conn, 'utf8mb4');

$id = 0;
if (isset($_GET['id']))       $id = (int)$_GET['id'];
elseif (isset($_POST['id']))  $id = (int)$_POST['id'];

if ($id <= 0 && isset($_GET['chasis'])) {
  $chasis = trim((string)$_GET['chasis']);
  if ($chasis !== '') {
    $q = "SELECT iddatadai FROM tb_datadai WHERE chasis = ? LIMIT 1";
    if ($st = $conn->prepare($q)) {
      $st->bind_param('s', $chasis);
      $st->execute();
      $st->bind_result($id);
      $st->fetch();
      $st->close();
    }
  }
}

if ($id <= 0) {
  echo json_encode(['data'=>[], 'error'=>'Parámetros inválidos']); exit;
}

$sql = "
  SELECT 
    b.idbateria,
    b.fecha,
    b.hora,
    b.estado,
    b.valor,
    m.unidad,
    b.resistencia,
    b.vida,
    b.foto,
    b.observacion
  FROM tb_bateria b
  LEFT JOIN tb_unidad_medida m ON m.id = b.id_unidad
  WHERE b.condicion = 1
    AND b.id_datadai = ?
  ORDER BY b.fecha DESC, b.hora DESC, b.idbateria DESC
";

$stmt = $conn->prepare($sql);
if (!$stmt) {
  echo json_encode(['data'=>[], 'error'=>'No se pudo preparar SELECT']); exit;
}
$stmt->bind_param('i', $id);
$stmt->execute();
$res = $stmt->get_result();

$rows = [];
while ($r = $res->fetch_assoc()) {
  $rows[] = [
    'fecha'       => $r['fecha'] ?? null,
    'hora'        => $r['hora'] ?? null,
    'estado'      => $r['estado'] ?? null,
    'valor'       => $r['valor'] ?? null,
    'unidad'      => $r['unidad'] ?? null,
    'resistencia' => $r['resistencia'] ?? null,
    'vida'        => $r['vida'] ?? null,
    'foto'        => $r['foto'] ?? null,
    'observacion' => $r['observacion'] ?? null,
  ];
}
$stmt->close();

echo json_encode(['data'=>$rows], JSON_UNESCAPED_UNICODE);
