<?php
// api/accesorio_save.php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }
session_start();
require_once __DIR__ . '/../conex.php';
mysqli_set_charset($conn,'utf8mb4');

$in = json_decode(file_get_contents('php://input'), true);
$id_accesorio = (int)($in['id_accesorio'] ?? 0);
$sku          = trim((string)($in['sku'] ?? ''));
$nombre       = trim((string)($in['nombre'] ?? ''));
$id_categoria = (int)($in['id_categoria'] ?? 0);
$descripcion  = (string)($in['descripcion'] ?? '');
$unidad       = trim((string)($in['unidad_medida'] ?? ''));
$codigo_bar   = trim((string)($in['codigo_barras'] ?? ''));
$attrs_raw    = $in['attrs'] ?? null;
$stock_min    = (int)($in['stock_min'] ?? 0);
$stock_max    = (int)($in['stock_max'] ?? 0);
$activo       = isset($in['activo']) ? (int)$in['activo'] : 1;
$condicion    = isset($in['condicion']) ? (int)$in['condicion'] : 1;

if ($sku==='' || $nombre==='' || $id_categoria<=0){
  echo json_encode(['success'=>false,'message'=>'SKU, Nombre y Categoría son obligatorios']); exit;
}
if ($stock_min<0 || $stock_max<0 || $stock_min>$stock_max){
  echo json_encode(['success'=>false,'message'=>'Rangos de stock inválidos']); exit;
}
$activo = ($activo===0?0:1);
$condicion = ($condicion===0?0:1);

/* Validar attrs como JSON o string JSON */
$attrs_sql = null;
if (!is_null($attrs_raw) && $attrs_raw!=='') {
  if (is_array($attrs_raw)) {
    $attrs_sql = json_encode($attrs_raw, JSON_UNESCAPED_UNICODE);
  } else {
    // si viene texto, validar que sea JSON
    $tmp = json_decode((string)$attrs_raw, true);
    if (json_last_error()!==JSON_ERROR_NONE){
      echo json_encode(['success'=>false,'message'=>'attrs debe ser JSON válido']); exit;
    }
    $attrs_sql = json_encode($tmp, JSON_UNESCAPED_UNICODE);
  }
}

if ($id_accesorio > 0) {
  $sql = "UPDATE tb_inv_accesorio
          SET sku=?, nombre=?, id_categoria=?, descripcion=?, unidad_medida=?, codigo_barras=?,
              attrs=?, stock_min=?, stock_max=?, activo=?, condicion=?
          WHERE id_accesorio=?";
  $stmt = mysqli_prepare($conn,$sql);
  mysqli_stmt_bind_param(
    $stmt,'ssisssssiiii',
    $sku,$nombre,$id_categoria,$descripcion,$unidad,$codigo_bar,
    $attrs_sql,$stock_min,$stock_max,$activo,$condicion,$id_accesorio
  );
  $ok = mysqli_stmt_execute($stmt);
  if (!$ok){
    $err = mysqli_error($conn);
    if (str_contains($err,'uq_acc_sku')) {
      echo json_encode(['success'=>false,'message'=>'SKU ya existe']); exit;
    }
    echo json_encode(['success'=>false,'message'=>'Error al actualizar']); exit;
  }
  echo json_encode(['success'=>true,'message'=>'Actualizado']);
} else {
  $sql = "INSERT INTO tb_inv_accesorio
          (sku,nombre,id_categoria,descripcion,unidad_medida,codigo_barras,attrs,stock_min,stock_max,activo,condicion)
          VALUES (?,?,?,?,?,?,?,?,?,?,?)";
  $stmt = mysqli_prepare($conn,$sql);
  mysqli_stmt_bind_param(
    $stmt,'ssisssssiii',
    $sku,$nombre,$id_categoria,$descripcion,$unidad,$codigo_bar,
    $attrs_sql,$stock_min,$stock_max,$activo,$condicion
  );
  $ok = mysqli_stmt_execute($stmt);
  if (!$ok){
    $err = mysqli_error($conn);
    if (str_contains($err,'uq_acc_sku')) {
      echo json_encode(['success'=>false,'message'=>'SKU ya existe']); exit;
    }
    echo json_encode(['success'=>false,'message'=>'Error al crear']); exit;
  }
  echo json_encode(['success'=>true,'message'=>'Creado','id'=>mysqli_insert_id($conn)]);
}
