<?php
//accesorio_ingreso.php — SGO · Inventario · Ingreso de Accesorio
declare(strict_types=1);
session_start();
if (!isset($_SESSION['ingreso']) || $_SESSION['ingreso'] !== 'YES') {
  header("Location: ../../views/index.php"); exit();
}
$usuario = $_SESSION['usuario'] ?? '';
$permiso = (int)($_SESSION['permiso'] ?? 0);
$id_usuario = (int)($_SESSION['id_usuario'] ?? 0);
?>
<?php include __DIR__ . '/partials/header.php'; ?>
<!doctype html>
<html lang="es" data-theme="light">
<head>
  <meta charset="utf-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1"/>
  <title>SGO · Inventario · Ingreso de Accesorio</title>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.datatables.net/1.13.8/css/dataTables.bootstrap5.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" referrerpolicy="no-referrer" />
  <link href="https://cdn.jsdelivr.net/npm/@sweetalert2/theme-bootstrap-4@5/bootstrap-4.min.css" rel="stylesheet">
  <style>
    :root { font-size: 15.5px; }
    html, body, .container-fluid, .row { height: 100%; }
    .flex-fill { min-height: 0; }
    .chip { padding:.15rem .5rem; border:1px solid #ddd; border-radius:999px; margin:.15rem; font-size:.85rem; background:#f8f9fa; }
    .chip .x { cursor:pointer; margin-left:.35rem; }
    .small-muted { font-size:.85rem; color:#6c757d; }
    .grid-2 { display:grid; grid-template-columns: 1fr 1fr; gap: .5rem;}
    .grid-3 { display:grid; grid-template-columns: 1fr 1fr 1fr; gap: .5rem;}
  </style>
</head>
<body>
<div class="container-fluid">
  <div class="row">
    <?php include __DIR__ . '/partials/menu.php'; ?>

    <main class="col-md-9 ms-sm-auto col-lg-10 px-3 py-3">
      <?php include __DIR__ . '/partials/topbar.php'; ?>

      <div class="d-flex align-items-center mb-3">
        <h5 class="mb-0"><i class="fa-solid fa-boxes-stacked me-2"></i> Ingreso de Accesorio</h5>
        <div class="ms-auto">
          <button id="btnGuardar" class="btn btn-primary btn-sm"><i class="fa-solid fa-save"></i> Guardar</button>
        </div>
      </div>

      <div class="row g-3">
        <div class="col-lg-8">
          <div class="card">
            <div class="card-header py-2">Datos del accesorio</div>
            <div class="card-body">
              <div class="row g-2">
                <div class="col-md-4">
                  <label class="form-label">SKU *</label>
                  <input id="sku" class="form-control" maxlength="60" required>
                </div>
                <div class="col-md-8">
                  <label class="form-label">Nombre *</label>
                  <input id="nombre" class="form-control" maxlength="150" required>
                </div>
                <div class="col-md-6">
                  <label class="form-label">Categoría *</label>
                  <select id="id_categoria" class="form-select" required></select>
                </div>
                <div class="col-md-3">
                  <label class="form-label">Unidad</label>
                  <input id="unidad_medida" class="form-control" placeholder="p.e. UN, PAR, JGO">
                </div>
                <div class="col-md-3">
                  <label class="form-label">Código barras</label>
                  <input id="codigo_barras" class="form-control">
                </div>
                <div class="col-12">
                  <label class="form-label">Descripción</label>
                  <textarea id="descripcion" class="form-control" rows="2"></textarea>
                </div>
                <div class="col-md-3">
                  <label class="form-label">Stock mín.</label>
                  <input id="stock_min" type="number" step="1" min="0" class="form-control" value="0">
                </div>
                <div class="col-md-3">
                  <label class="form-label">Stock máx.</label>
                  <input id="stock_max" type="number" step="1" min="0" class="form-control" value="0">
                </div>
                <div class="col-md-6">
                  <label class="form-label">Atributos (JSON opcional)</label>
                  <input id="attrs" class="form-control" placeholder='{"color":"negro","voltaje":"12V"}'>
                  <div class="small-muted">Si no usas atributos, deja vacío.</div>
                </div>
              </div>
            </div>
          </div>

          <div class="card mt-3">
            <div class="card-header py-2">Partes</div>
            <div class="card-body">
              <div class="d-flex gap-2">
                <select id="selParte" class="form-select" style="max-width:360px"></select>
                <button id="btnAddParte" class="btn btn-outline-primary"><i class="fa-solid fa-plus"></i> Agregar</button>
              </div>
              <div id="chipsPartes" class="mt-2"></div>
            </div>
          </div>

          <div class="card mt-3">
            <div class="card-header py-2">Compatibilidad (Marca / Modelo)</div>
            <div class="card-body">
              <div class="grid-3">
                <div>
                  <label class="form-label">Marca</label>
                  <select id="selMarca" class="form-select"></select>
                </div>
                <div>
                  <label class="form-label">Modelo</label>
                  <select id="selModelo" class="form-select"></select>
                </div>
                <div>
                  <label class="form-label">Años</label>
                  <div class="d-flex gap-2">
                    <input id="anio_desde" type="number" class="form-control" placeholder="Desde">
                    <input id="anio_hasta" type="number" class="form-control" placeholder="Hasta">
                  </div>
                </div>
              </div>
              <div class="mt-2 d-flex gap-2">
                <input id="observacion" class="form-control" placeholder="Observación (opcional)">
                <button id="btnAddCompat" class="btn btn-outline-primary"><i class="fa-solid fa-plus"></i> Agregar</button>
              </div>
              <div class="table-responsive mt-2">
                <table class="table table-sm align-middle">
                  <thead><tr><th>Marca</th><th>Modelo</th><th>Años</th><th>Obs.</th><th style="width:60px"></th></tr></thead>
                  <tbody id="tbCompat"></tbody>
                </table>
              </div>
            </div>
          </div>

        </div>

        <div class="col-lg-4">
          <div class="card">
            <div class="card-header py-2">Ingreso de stock inicial</div>
            <div class="card-body">
              <div class="mb-2">
                <label class="form-label">Bodega destino *</label>
                <select id="id_bodega" class="form-select" required></select>
              </div>
              <div class="mb-2">
                <label class="form-label">Ubicación</label>
                <select id="id_ubicacion" class="form-select"></select>
              </div>
              <div class="mb-2">
                <label class="form-label">Cantidad *</label>
                <input id="cantidad" type="number" step="0.01" min="0.01" class="form-control" required>
              </div>
              <div class="mb-2">
                <label class="form-label">Motivo</label>
                <input id="motivo" class="form-control" placeholder="Ingreso inicial, compra, ajuste...">
              </div>
              <div class="grid-2">
                <div>
                  <label class="form-label">Ref. Tipo</label>
                  <input id="ref_tipo" class="form-control" placeholder="OC, FAC, AJUSTE">
                </div>
                <div>
                  <label class="form-label">Ref. ID</label>
                  <input id="ref_id" class="form-control" placeholder="# documento">
                </div>
              </div>
            </div>
          </div>
          <div class="form-check mt-3">
            <input id="activo" class="form-check-input" type="checkbox" checked>
            <label class="form-check-label" for="activo">Accesorio activo</label>
          </div>
        </div>
      </div>
    </main>
  </div>
</div>

<?php include __DIR__ . '/partials/footer.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
// Helper fetchJSON: muestra HTML de error si la API no devuelve JSON
async function fetchJSON(url, options){
  const res = await fetch(url, options);
  const txt = await res.text();
  if (!res.ok) {
    console.error('HTTP', res.status, txt);
    Swal.fire('Error ' + res.status, txt.slice(0,400), 'error');
    throw new Error('HTTP '+res.status);
  }
  try { return JSON.parse(txt); }
  catch(e){ console.error('NO-JSON', txt); Swal.fire('Error', txt.slice(0,400), 'error'); throw e; }
}
</script>

<script>
const apiBase = (window.SGO_API_BASE ?? 'api/');
const partesSel = new Map();   // id_parte -> nombre
const compatList = [];         // {id_marca, marca, id_modelo, modelo, anio_desde, anio_hasta, observacion}

document.addEventListener('DOMContentLoaded', () => {
  cargarRef();
  document.getElementById('btnAddParte').addEventListener('click', addParte);
  document.getElementById('btnAddCompat').addEventListener('click', addCompat);
  document.getElementById('selMarca').addEventListener('change', onMarcaChange);
  document.getElementById('id_bodega').addEventListener('change', onBodegaChange);
  document.getElementById('btnGuardar').addEventListener('click', guardar);
});

async function cargarRef(){
  try {
    const ref = await fetchJSON(`${apiBase}ingreso_refdata.php?_=${Date.now()}`);
    llenarSelect(document.getElementById('id_categoria'), ref.categorias, 'id_categoria','nombre','— Seleccione —');
    llenarSelect(document.getElementById('selParte'), ref.partes, 'id_parte','nombre','— Parte —');
    llenarSelect(document.getElementById('selMarca'), ref.marcas, 'id_marca','nombre','— Marca —');
    llenarSelect(document.getElementById('selModelo'), [], 'id_modelo','nombre','— Modelo —');
    llenarSelect(document.getElementById('id_bodega'), ref.bodegas, 'id_bodega','nombre','— Bodega —');
    llenarSelect(document.getElementById('id_ubicacion'), [], 'id_ubicacion','nombre','— Ubicación —');
  } catch(e){}
}

function llenarSelect(sel, data, val, txt, placeholder){
  sel.innerHTML = '';
  if (placeholder) sel.append(new Option(placeholder,''));
  (data||[]).forEach(o => sel.append(new Option(o[txt], o[val])));
}

async function onMarcaChange(e){
  const id_marca = parseInt(e.target.value || '0');
  const modelos = (await fetchJSON(`${apiBase}ingreso_refdata.php?modelos=1&id_marca=${id_marca}`)).modelos || [];
  llenarSelect(document.getElementById('selModelo'), modelos, 'id_modelo','nombre','— Modelo —');
}

async function onBodegaChange(e){
  const id_bod = parseInt(e.target.value || '0');
  const ubis = (await fetchJSON(`${apiBase}ubicaciones_por_bodega.php?id_bodega=${id_bod}`)).data || [];
  llenarSelect(document.getElementById('id_ubicacion'), ubis, 'id_ubicacion','nombre','— Ubicación —');
}

function addParte(e){
  e.preventDefault();
  const sel = document.getElementById('selParte');
  const id = parseInt(sel.value || '0'); if (!id) return;
  const txt = sel.options[sel.selectedIndex].text;
  if (partesSel.has(id)) return;
  partesSel.set(id, txt);
  renderChipsPartes();
}
function renderChipsPartes(){
  const wrap = document.getElementById('chipsPartes');
  wrap.innerHTML = '';
  partesSel.forEach((nombre, id)=>{
    const span = document.createElement('span');
    span.className = 'chip';
    span.textContent = nombre + ' ';
    const x = document.createElement('span'); x.textContent = '×'; x.className='x';
    x.onclick = ()=>{ partesSel.delete(id); renderChipsPartes(); };
    span.appendChild(x);
    wrap.appendChild(span);
  });
}

function addCompat(e){
  e.preventDefault();
  const selM = document.getElementById('selMarca');
  const selMo= document.getElementById('selModelo');
  const id_marca  = parseInt(selM.value || '0');
  const id_modelo = parseInt(selMo.value || '0');
  if (!id_marca || !id_modelo) { Swal.fire('Validación','Selecciona marca y modelo','info'); return; }
  const marca  = selM.options[selM.selectedIndex].text;
  const modelo = selMo.options[selMo.selectedIndex].text;
  const anio_desde = parseInt(document.getElementById('anio_desde').value || '0') || null;
  const anio_hasta = parseInt(document.getElementById('anio_hasta').value || '0') || null;
  const observacion= document.getElementById('observacion').value || '';

  // evita duplicados marca+modelo+años (normaliza null)
  const key = `${id_marca}|${id_modelo}|${anio_desde||''}|${anio_hasta||''}|${observacion.trim()}`;
  if (compatList.some(c => `${c.id_marca}|${c.id_modelo}|${c.anio_desde||''}|${c.anio_hasta||''}|${(c.observacion||'').trim()}`===key)) return;

  compatList.push({ id_marca, marca, id_modelo, modelo, anio_desde, anio_hasta, observacion });
  renderCompat();
}
function renderCompat(){
  const tb = document.getElementById('tbCompat');
  tb.innerHTML = '';
  compatList.forEach((c, idx)=>{
    const tr = document.createElement('tr');
    tr.innerHTML = `
      <td>${c.marca}</td>
      <td>${c.modelo}</td>
      <td>${c.anio_desde||''} - ${c.anio_hasta||''}</td>
      <td>${c.observacion||''}</td>
      <td class="text-end"><button class="btn btn-sm btn-outline-danger" onclick="delCompat(${idx})"><i class="fa-solid fa-xmark"></i></button></td>
    `;
    tb.appendChild(tr);
  });
}
function delCompat(i){ compatList.splice(i,1); renderCompat(); }

async function guardar(){
  // validar básico
  const sku = document.getElementById('sku').value.trim();
  const nombre = document.getElementById('nombre').value.trim();
  const id_categoria = parseInt(document.getElementById('id_categoria').value||'0');
  const id_bodega = parseInt(document.getElementById('id_bodega').value||'0');
  const cantidad = parseFloat(document.getElementById('cantidad').value||'0');
  if (!sku || !nombre || !id_categoria) return Swal.fire('Validación','Completa SKU, Nombre y Categoría','info');
  if (!id_bodega || !(cantidad>0)) return Swal.fire('Validación','Completa bodega y cantidad','info');

  // arma payload
  const payload = {
    accesorio:{
      sku,
      nombre,
      id_categoria,
      descripcion: document.getElementById('descripcion').value || '',
      unidad_medida: document.getElementById('unidad_medida').value || '',
      codigo_barras: document.getElementById('codigo_barras').value || '',
      attrs: document.getElementById('attrs').value || '',
      stock_min: parseInt(document.getElementById('stock_min').value||'0')||0,
      stock_max: parseInt(document.getElementById('stock_max').value||'0')||0,
      activo: document.getElementById('activo').checked ? 1 : 0,
    },
    partes: Array.from(partesSel.keys()),
    compatibilidades: compatList.map(c => ({
      id_modelo: c.id_modelo,
      anio_desde: c.anio_desde,
      anio_hasta: c.anio_hasta,
      observacion: c.observacion
    })),
    ingreso:{
      id_bodega,
      id_ubicacion: parseInt(document.getElementById('id_ubicacion').value||'0')||null,
      cantidad,
      motivo: document.getElementById('motivo').value || 'Ingreso inicial',
      ref_tipo: document.getElementById('ref_tipo').value || '',
      ref_id: document.getElementById('ref_id').value || '',
      id_usuario: <?php echo (int)$id_usuario; ?>
    }
  };

  try{
    const res = await fetchJSON(`${apiBase}accesorio_ingreso_save.php`, {
      method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify(payload)
    });
    if (!res.success) return Swal.fire('Atención', res.message||'No se pudo guardar', 'warning');
    Swal.fire('Éxito', res.message || 'Guardado', 'success');
    // limpiar formulario
    location.reload();
  }catch(e){}
}
</script>

</body>
</html>
