<?php
if (!function_exists('generarHtmlAsignacion')) {
  function generarHtmlAsignacion($nombre, $destinoTxt, $vehiculos, $panelUrl) {
    $rows = '';
    foreach ($vehiculos as $v) {
      $rows .= '<tr>'
        .'<td style="padding:8px;border:1px solid #ddd;">'.htmlspecialchars($v['chasis']).'</td>'
        .'<td style="padding:8px;border:1px solid #ddd;">'.htmlspecialchars($v['marca']).'</td>'
        .'<td style="padding:8px;border:1px solid #ddd;">'.htmlspecialchars($v['modelo']).'</td>'
        .'<td style="padding:8px;border:1px solid #ddd;">'.htmlspecialchars($v['color']).'</td>'
      .'</tr>';
    }
    return '<div style="font-family:Arial,sans-serif;font-size:14px;color:#333;">'
      .'<p>Hola <b>'.htmlspecialchars($nombre).'</b>,</p>'
      .'<p>Se han asignado nuevas unidades con destino <b>'.htmlspecialchars($destinoTxt ?: 'N/D').'</b>.</p>'
      .'<table style="border-collapse:collapse;width:100%;max-width:700px;"><thead><tr>'
      .'<th style="padding:8px;border:1px solid #ddd;">Chasis</th>'
      .'<th style="padding:8px;border:1px solid #ddd;">Marca</th>'
      .'<th style="padding:8px;border:1px solid #ddd;">Modelo</th>'
      .'<th style="padding:8px;border:1px solid #ddd;">Color</th>'
      .'</tr></thead><tbody>'.$rows.'</tbody></table>'
      .'<p style="margin-top:16px;"><a href="'.htmlspecialchars($panelUrl).'" '
      .'style="display:inline-block;padding:10px 16px;background:#0d6efd;color:#fff;text-decoration:none;border-radius:6px;">'
      .'Abrir panel</a></p></div>';
  }
}

if (!function_exists('generarTextoPlanoAsignacion')) {
  function generarTextoPlanoAsignacion($nombre, $destinoTxt, $vehiculos, $panelUrl) {
    $lineas = [];
    foreach ($vehiculos as $v) {
      $lineas[] = "Chasis: {$v['chasis']} - Marca: {$v['marca']} - Modelo: {$v['modelo']} - Color: {$v['color']}";
    }
    return "Hola {$nombre},\n\nSe han asignado nuevas unidades con destino ".($destinoTxt ?: 'N/D')
      .".\n\n".implode("\n", $lineas)."\n\nAbrir panel: {$panelUrl}\n";
  }
}
