<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>SGO - Inicio de Sesión</title>
  <link rel="shortcut icon" href="resources/img/icon.ico">

  <!-- Bootstrap 5 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Font Awesome 6 -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

  <style>
    body {
      padding-top: 90px;
      background-color: #f5f5f5;
      transition: background-color 0.3s, color 0.3s;
    }
    body.dark-mode {
      background-color: #1e1e1e;
      color: #f0f0f0;
    }
    #sha {
      max-width: 350px;
      margin: auto;
      padding: 20px;
      border-radius: 8px;
      box-shadow: 0 0 8px rgba(0,0,0,0.2);
      background-color: #fff;
      transition: background-color 0.3s, color 0.3s;
    }
    body.dark-mode #sha {
      background-color: #2c2c2c;
      color: #f0f0f0;
    }
    .form-control:focus {
      box-shadow: none;
    }
    #login {
      width: 100%;
      max-width: 300px;
      margin: 0 auto;
      display: block;
    }
    .footer-text {
      font-size: 12px;
      color: #777;
    }
    .dark-mode .footer-text {
      color: #aaa;
    }
    #loader {
      display: none;
      margin-bottom: 10px;
    }
    #toggle-dark {
      margin-top: 10px;
      font-size: 12px;
      cursor: pointer;
      text-align: center;
      color: #007bff;
    }
    .dark-mode #toggle-dark {
      color: #66b0ff;
    }
  </style>
</head>
<body>
  <div class="container" id="sha">
    <div class="text-center">
      <img src="resources/img/mesa_trabajo3.png" class="img-fluid" id="login" alt="Logo SGO">
    </div>

    <div id="loader" class="text-center">
      <i class="fas fa-spinner fa-spin fa-2x text-primary"></i>
    </div>

    <div class="alert alert-danger text-center" style="display:none;" id="error"></div>

    <form onsubmit="return confirmar();" class="mt-3">
      <div class="mb-3">
        <input name="usuario" id="usuario" type="text" class="form-control" placeholder="Usuario" required autofocus autocomplete="username">
      </div>

      <div class="mb-3 input-group">
        <input name="pass" id="pass" type="password" class="form-control" placeholder="Contraseña" required autocomplete="current-password">
        <button class="btn btn-outline-secondary" type="button" onclick="togglePassword()" title="Mostrar/Ocultar">
          <i class="fa-solid fa-eye" id="eye-icon"></i>
        </button>
      </div>     

      <button id="btn-login" class="btn btn-primary w-100" type="submit">Iniciar sesión</button>
    </form>    
    <p class="footer-text text-center mt-3">Se recomienda usar Chrome o Firefox (v. +58)</p>
    <p class="footer-text text-center">&copy; LATKIC S.A. - Todos los derechos reservados</p>
    
  </div>


  <!-- Scripts -->
  <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    function confirmar() {
      const usuario = $('#usuario').val().trim();
      const pass = $('#pass').val().trim();
      const recordar = $('#recordar').is(':checked');

      if (!usuario || !pass) {
        $('#error').text('Complete ambos campos').show();
        return false;
      }

      $('#error').hide();
      $('#loader').show();
      $('#btn-login').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Validando...');

      $.ajax({
        url: 'controllers/usuario.php',
        type: 'POST',
        data: { usuario, pass, recordar, boton: 'ingresar' },
        success: function(resp) {
          $('#loader').hide();
          $('#btn-login').prop('disabled', false).text('Iniciar sesión');

          if (resp == 0) {
            window.location.href = 'views/menu.php';
          } else {
            $('#error').text('Usuario o contraseña incorrectos').show();
          }
        },
        error: function() {
          $('#loader').hide();
          $('#btn-login').prop('disabled', false).text('Iniciar sesión');
          $('#error').text('Error en el servidor. Intente más tarde.').show();
        }
      });

      return false;
    }

    function togglePassword() {
      const passField = document.getElementById("pass");
      const icon = document.getElementById("eye-icon");

      if (passField.type === "password") {
        passField.type = "text";
        icon.classList.remove("fa-eye");
        icon.classList.add("fa-eye-slash");
      } else {
        passField.type = "password";
        icon.classList.remove("fa-eye-slash");
        icon.classList.add("fa-eye");
      }
    }

    function toggleDarkMode() {
      document.body.classList.toggle('dark-mode');
    }

    $(document).on('keydown', function(e) {
      if (e.which === 13) confirmar();
    });
  </script>
</body>
</html>
