<?php
session_start();
include("conex.php");

// Validar sesión
if (!isset($_SESSION['idusuario'])) {
    die("Acceso denegado: Sesión no iniciada.");
}

// Obtener datos del formulario
$idusuario = $_SESSION['idusuario'];
$idfi = $_POST['idfi'] ?? null;
$numero = $_POST['numero'] ?? null;
$fecha = $_POST['fecha'] ?? null;
$razon = $_POST['razon'] ?? null;
$cedula = $_POST['cedula'] ?? null;
$pedido = $_POST['pedido'] ?? null;
$sp = $_POST['sp'] ?? null;
$dai = $_POST['dai'] ?? null;

// Validar que los datos requeridos no estén vacíos
if (!$idfi || !$numero || !$fecha || !$razon || !$cedula || !$pedido || !$sp || !$dai) {
    die("Error: Todos los campos son obligatorios.");
}

// Variables auxiliares
$actividad = "Actualizar factura informativa";
$my_ip = $_SERVER["REMOTE_ADDR"];
date_default_timezone_set('America/Guayaquil');
$fecha_actual = date('Y-m-d');
$time_actual = date('H:i:s');

// Iniciar transacción
mysqli_begin_transaction($conn);

try {
    // Actualizar datos en la tabla `tb_facturainfo`
    $stmt_update = $conn->prepare("
        UPDATE tb_facturainfo
        SET numero = ?, fecha = ?, cedula = ?, nombre = ?, pedido = ?, sp = ?, dai = ?
        WHERE idfacturainfo = ?
    ");
    $stmt_update->bind_param("sssssssi", $numero, $fecha, $cedula, $razon, $pedido, $sp, $dai, $idfi);
    $stmt_update->execute();

    // Registrar la auditoría
    $stmt_audit = $conn->prepare("
        INSERT INTO tb_auditoria (fecha, hora, ip, detalle, id_facturainfo, id_usuario)
        VALUES (?, ?, ?, ?, ?, ?)
    ");
    $stmt_audit->bind_param("ssssii", $fecha_actual, $time_actual, $my_ip, $actividad, $idfi, $idusuario);
    $stmt_audit->execute();

    // Confirmar transacción
    mysqli_commit($conn);

    //echo "Factura informativa actualizada correctamente.";
} catch (Exception $e) {
    // Revertir cambios en caso de error
    mysqli_rollback($conn);
    echo "Error: " . $e->getMessage();
} finally {
    // Cerrar recursos
    if (isset($stmt_update)) $stmt_update->close();
    if (isset($stmt_audit)) $stmt_audit->close();
    $conn->close();
}
?>
